/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.configmaster.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import me.xginko.aef.libs.configmaster.annotations.Example;
import me.xginko.aef.libs.configmaster.annotations.Option;
import me.xginko.aef.libs.configmaster.annotations.OptionHandler;
import me.xginko.aef.libs.configmaster.annotations.handlers.BooleanOptionHandler;
import me.xginko.aef.libs.configmaster.annotations.handlers.DefaultOptionHandler;
import me.xginko.aef.libs.configmaster.annotations.handlers.FloatOptionHandler;
import me.xginko.aef.libs.configmaster.annotations.handlers.IntegerOptionHandler;
import me.xginko.aef.libs.configmaster.annotations.handlers.LongOptionHandler;
import me.xginko.aef.libs.configmaster.annotations.handlers.StringOptionHandler;
import me.xginko.aef.libs.configmaster.api.CommentWriter;
import me.xginko.aef.libs.configmaster.api.Title;
import me.xginko.aef.libs.configmaster.api.comments.Comment;
import me.xginko.aef.libs.configmaster.impl.CMConfigSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class ConfigFile
extends CMConfigSection {
    @NotNull
    private static final HashMap<Class<?>, Class<? extends OptionHandler>> REGISTERED_HANDLERS = new HashMap();
    @NotNull
    private final Yaml yaml = this.getYaml();
    @NotNull
    private final File file;
    @NotNull
    private final CommentWriter writer;
    @NotNull
    protected List<Comment> pendingComments;
    @NotNull
    protected HashMap<String, List<Comment>> comments;
    @NotNull
    protected HashSet<String> examples;
    @NotNull
    protected List<String> lenientSections;
    @NotNull
    protected Function<String, String> optionNameTranslator;
    @NotNull
    protected List<String> permittedClasses;
    @Nullable
    private Title title;
    private boolean isNew;
    protected boolean verbose;
    protected boolean reloading;
    protected static Logger logger = new CMLogger();

    public ConfigFile(@NotNull File file) throws IOException, IllegalAccessException {
        this(file, (String name) -> name.replaceAll("_", "-").toLowerCase());
    }

    public ConfigFile(@NotNull File file, @NotNull Function<String, String> optionNameTranslator) throws IOException, IllegalAccessException {
        this.file = file;
        this.optionNameTranslator = optionNameTranslator;
        this.isNew = false;
        this.reloading = false;
        this.title = null;
        this.writer = new CommentWriter(this);
        this.pendingComments = new ArrayList<Comment>();
        this.comments = new HashMap();
        this.examples = new HashSet();
        this.lenientSections = new ArrayList<String>();
        this.permittedClasses = new ArrayList<String>();
    }

    public static ConfigFile loadConfig(File file) throws Exception {
        ConfigFile configFile = new ConfigFile(file);
        configFile.createFile();
        configFile.loadContent();
        return configFile;
    }

    public void load() throws Exception {
        this.preFileCreation();
        this.createFile();
        this.loadContent();
        this.addDefaults();
        this.moveToNew();
        this.save();
        this.postSave();
    }

    public void preFileCreation() {
    }

    protected void loadFromString(String content) throws IOException {
        try {
            Map map = (Map)this.yaml.load(content);
            if (map != null) {
                this.mapToCM(map);
            }
        }
        catch (YAMLException exception) {
            File tempFile = new File(this.file.getParentFile(), this.file.getName().substring(0, this.file.getName().lastIndexOf(".")) + "-errored-" + System.currentTimeMillis() + ".yml");
            Files.copy(this.file.toPath(), tempFile.toPath(), new CopyOption[0]);
            logger.severe("YAMLException caught - there is a syntax error in the config.");
            exception.printStackTrace();
        }
    }

    public void addDefaults() throws Exception {
        this.handleAnnotations((field, option) -> {
            if (!this.canProcessOption((Field)field, (Option)option)) {
                return;
            }
            Object defaultOpt = field.get(this);
            String name = option.path().isEmpty() ? this.optionNameTranslator.apply(field.getName()) : option.path();
            String comment = option.comment().isEmpty() ? null : option.comment();
            String section = option.section().isEmpty() ? null : option.section();
            boolean lenient = option.lenient();
            Class<? extends OptionHandler> optionHandlerClass = option.optionHandler();
            if (optionHandlerClass == DefaultOptionHandler.class) {
                optionHandlerClass = REGISTERED_HANDLERS.getOrDefault(field.getType(), DefaultOptionHandler.class);
            }
            OptionHandler handler = optionHandlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Example example : (Example[])field.getAnnotationsByType(Example.class)) {
                this.addExample(name + "." + example.key(), example.value());
            }
            if (lenient) {
                if (comment != null) {
                    this.addComment(name, comment);
                }
                this.makeSectionLenient(name);
            }
            if (defaultOpt != null) {
                handler.addDefault(this, name, defaultOpt, section, comment);
            }
            field.set(this, handler.get(this, name));
        });
    }

    public boolean canProcessOption(@NotNull Field field, @NotNull Option option) {
        return true;
    }

    public void loadContent() throws IOException {
        this.loadFromString(this.readFileContent());
    }

    public void moveToNew() {
    }

    public void postSave() {
    }

    public void save() throws Exception {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String saved = this.saveToString();
            writer.write(saved);
            this.isNew = false;
            this.existingValues.clear();
        }
    }

    protected String readFileContent() throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
            if (content.length() == 0) {
                this.isNew = true;
            }
        }
        return content.toString();
    }

    public void reload() throws Exception {
        this.debug("Reloading the configuration file " + this.file.getName() + "...");
        this.reloading = true;
        LinkedHashMap<String, Object> allDefaults = new LinkedHashMap<String, Object>();
        this.addDefaults(allDefaults);
        this.createFile();
        this.existingValues.clear();
        this.clear();
        this.loadContent();
        for (String path : ((HashMap)allDefaults).keySet()) {
            String parentPath = this.getParentPath(path);
            if (this.lenientSections.contains(parentPath)) {
                this.makeSectionLenient(parentPath);
                continue;
            }
            if (this.examples.contains(path) && !this.contains(path) && !this.isNew) continue;
            this.addDefault(path, ((HashMap)allDefaults).get(path));
        }
        this.addDefaults();
        this.moveToNew();
        this.save();
        this.postSave();
        this.reloading = false;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isReloading() {
        return this.reloading;
    }

    protected void createFile() throws IOException {
        if (!this.file.exists()) {
            if (!this.file.createNewFile()) {
                throw new IOException("Failed to create " + this.file.getName() + "!");
            }
            this.isNew = true;
        }
    }

    public void updateAnnotations() throws Exception {
        this.handleAnnotations((field, option) -> {
            Object value = field.get(this);
            String name = option.path().isEmpty() ? this.optionNameTranslator.apply(field.getName()) : option.path();
            this.set(name, value);
        });
    }

    private void handleAnnotations(OptionConsumer<Field, Option> consumer) throws Exception {
        Field[] fields;
        for (Field field : fields = this.getClass().getFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            Option option = field.getAnnotation(Option.class);
            consumer.accept(field, option);
        }
    }

    public String saveToString() throws Exception {
        this.updateAnnotations();
        String dump = this.yaml.dump(this.convertToMap());
        if (dump.equals("{}")) {
            dump = "";
        }
        this.writer.writeComments(new ArrayList<String>(Arrays.asList(dump.split("\n"))));
        StringBuilder result = new StringBuilder();
        this.writer.getLines().forEach((? super T line) -> result.append((String)line).append("\n"));
        return (this.title != null ? this.title + "\n" : "") + result;
    }

    @NotNull
    public HashMap<String, List<Comment>> getComments() {
        return this.comments;
    }

    @NotNull
    public List<Comment> getPendingComments() {
        return this.pendingComments;
    }

    @NotNull
    public HashSet<String> getExamples() {
        return this.examples;
    }

    @NotNull
    public List<String> getLenientSections() {
        return this.lenientSections;
    }

    @Nullable
    public Title getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable Title title) {
        this.title = title;
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    public ConfigFile enableDebugging() {
        this.verbose = true;
        return this;
    }

    public void debug(String message) {
        if (this.verbose) {
            logger.info(message);
        }
    }

    private Yaml getYaml() {
        Yaml yaml;
        Representer representerClone;
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        try {
            representerClone = new Representer(options);
        }
        catch (NoSuchMethodError ex) {
            try {
                representerClone = (Representer)Representer.class.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        representerClone.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        try {
            LoaderOptions loader = new LoaderOptions();
            loader.setCodePointLimit(0x6400000);
            loader.setTagInspector(tag -> this.permittedClasses.contains(tag.getClassName()));
            yaml = new Yaml((BaseConstructor)new SafeConstructor(loader), representerClone, options, loader);
        }
        catch (Exception | NoClassDefFoundError | NoSuchMethodError ex) {
            try {
                yaml = new Yaml((BaseConstructor)SafeConstructor.class.getConstructor(new Class[0]).newInstance(new Object[0]), representerClone, options);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return yaml;
    }

    static {
        REGISTERED_HANDLERS.put(Boolean.TYPE, BooleanOptionHandler.class);
        REGISTERED_HANDLERS.put(Boolean.class, BooleanOptionHandler.class);
        REGISTERED_HANDLERS.put(Float.TYPE, FloatOptionHandler.class);
        REGISTERED_HANDLERS.put(Float.class, FloatOptionHandler.class);
        REGISTERED_HANDLERS.put(Integer.TYPE, IntegerOptionHandler.class);
        REGISTERED_HANDLERS.put(Integer.class, IntegerOptionHandler.class);
        REGISTERED_HANDLERS.put(Long.TYPE, LongOptionHandler.class);
        REGISTERED_HANDLERS.put(Long.class, LongOptionHandler.class);
        REGISTERED_HANDLERS.put(String.class, StringOptionHandler.class);
    }

    private static interface OptionConsumer<T, R> {
        public void accept(T var1, R var2) throws Exception;
    }

    private static class CMLogger
    extends Logger {
        protected CMLogger() {
            super("ConfigurationMaster", null);
        }
    }
}

