/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.configmaster.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public class Title {
    private final List<TitlePart> parts = new ArrayList<TitlePart>();
    private int width = 75;
    private boolean addPadding = true;

    public Title withWidth(int width) {
        if (!this.parts.isEmpty()) {
            throw new IllegalStateException("Cannot adjust the title width after title content has been added!");
        }
        this.width = width;
        return this;
    }

    public Title withPadding(boolean padding) {
        if (!this.parts.isEmpty()) {
            throw new IllegalStateException("Cannot adjust padding status after title content has been added!");
        }
        this.addPadding = padding;
        return this;
    }

    public Title addSolidLine() {
        return this.addSolidLine('#');
    }

    public Title addSolidLine(char character) {
        this.parts.add(new LineTitlePart(character));
        return this;
    }

    public Title addLine(@NotNull String content) {
        return this.addLine(content, Pos.LEFT);
    }

    public Title addLine(@NotNull String content, @NotNull Pos position) {
        Objects.requireNonNull(content, "Title content must not be null!");
        Objects.requireNonNull(position, "Position must not be null!");
        if (content.length() < this.width - 3) {
            this.parts.add(new TextTitlePart(content, position));
            return this;
        }
        StringJoiner joiner = new StringJoiner(" ");
        for (String word : content.split(" ")) {
            if (word.length() > this.width - 4) {
                throw new IllegalArgumentException(String.format("Word %s of size %s is too long to be fit into the title (%s)!", word, word.length(), this.width - 4));
            }
            if ((joiner + " " + word).length() < this.width - 3) {
                joiner.add(word);
                continue;
            }
            this.parts.add(new TextTitlePart(joiner.toString(), position));
            joiner = new StringJoiner(" ").add(word);
        }
        if (joiner.length() == 0) {
            return this;
        }
        this.parts.add(new TextTitlePart(joiner.toString(), position));
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TitlePart part : this.parts) {
            if (builder.length() != 0) {
                builder.append("\n");
            }
            builder.append(part.toString());
        }
        return builder.toString();
    }

    private String align(String content, Pos position) {
        int remainder = this.width - 4 - content.length();
        switch (position) {
            case LEFT: {
                return "# " + content + Title.repeat(" ", remainder);
            }
            case RIGHT: {
                return "# " + Title.repeat(" ", remainder) + content;
            }
            case CENTER: {
                return "# " + Title.repeat(" ", remainder / 2) + content + Title.repeat(" ", remainder % 2 == 1 ? remainder / 2 + 1 : remainder / 2);
            }
        }
        return content;
    }

    private static String repeat(String str, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(str);
        }
        return builder.toString();
    }

    public static abstract class TitlePart {
        protected Pos position;

        public TitlePart(Pos pos) {
            this.position = pos;
        }

        public abstract String toString();
    }

    private class LineTitlePart
    extends TitlePart {
        private final char character;

        public LineTitlePart(char character) {
            super(Pos.LEFT);
            this.character = character;
        }

        @Override
        public String toString() {
            if (this.character == '#') {
                return Title.repeat("#", Title.this.width);
            }
            return "# " + Title.repeat(String.valueOf(this.character), Title.this.width - 4) + (Title.this.addPadding ? " #" : "");
        }
    }

    private class TextTitlePart
    extends TitlePart {
        private final String content;

        public TextTitlePart(String content, Pos pos) {
            super(pos);
            this.content = content;
        }

        @Override
        public String toString() {
            return Title.this.align(this.content, this.position) + (Title.this.addPadding ? " #" : "");
        }
    }

    public static enum Pos {
        LEFT,
        CENTER,
        RIGHT;

    }
}

