/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.configmaster.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import me.xginko.aef.libs.configmaster.api.ConfigFile;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.configmaster.api.comments.Comment;
import me.xginko.aef.libs.configmaster.api.comments.Section;
import me.xginko.aef.libs.configmaster.impl.CMMemorySection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMConfigSection
extends CMMemorySection
implements ConfigSection {
    public CMConfigSection() {
    }

    public CMConfigSection(String path, ConfigFile file) {
        super(path, file);
    }

    @Override
    public void addDefault(@NotNull String path, @Nullable Object defaultOption) {
        this.addDefault(path, defaultOption, null, null);
    }

    @Override
    public void addDefault(@NotNull String path, @Nullable Object defaultOption, @Nullable String comment) {
        this.addDefault(path, defaultOption, null, comment);
    }

    @Override
    public void addDefault(@NotNull String path, @Nullable Object defaultOption, @Nullable String section, @Nullable String comment) {
        Objects.requireNonNull(path, "The path cannot be null!");
        String fullPath = this.getPathWithKey(path);
        CMMemorySection cmSection = this.getSectionInternal(path);
        if (cmSection == null) {
            cmSection = this.createSectionInternal(path);
        }
        String key = this.getKey(path);
        if (!this.getParent().isReloading()) {
            this.addPendingCommentsToPath(path);
            ArrayList<Comment> comments = new ArrayList<Comment>();
            if (this.getParent().getComments().containsKey(fullPath)) {
                comments.addAll((Collection)this.getParent().getComments().get(fullPath));
            }
            if (section != null) {
                comments.add(new Section(section));
            }
            if (comment != null) {
                comments.add(new Comment(comment));
            }
            this.getParent().getPendingComments().clear();
            if (comments.size() > 0) {
                this.getParent().getComments().put(fullPath, comments);
            }
        }
        cmSection.defaults.put(key, defaultOption);
        cmSection.put(key, cmSection.existingValues.getOrDefault(key, defaultOption));
    }

    @Override
    public void addComment(@NotNull String comment) {
        if (this.getParent().isReloading()) {
            return;
        }
        this.getParent().getPendingComments().add(new Comment(comment));
    }

    @Override
    public void moveTo(@NotNull String oldPath, @NotNull String newPath) {
        this.moveTo(oldPath, newPath, this.getParent());
    }

    @Override
    public void moveTo(@NotNull String oldPath, @NotNull String newPath, @NotNull ConfigFile otherFile) {
        Objects.requireNonNull(oldPath, "The old path cannot be null!");
        Objects.requireNonNull(newPath, "The new path cannot be null!");
        Objects.requireNonNull(otherFile, "The file being transferred to cannot be null!");
        if (!this.contains(oldPath)) {
            return;
        }
        CMMemorySection oldCmSection = this.getSectionInternal(oldPath, false);
        if (oldCmSection == null) {
            return;
        }
        CMMemorySection newCmSection = otherFile.getSectionInternal(newPath);
        if (newCmSection == null) {
            newCmSection = otherFile.createSectionInternal(newPath);
        }
        String oldKey = oldPath.substring(oldPath.lastIndexOf(46) + 1);
        Object movingValue = oldCmSection.existingValues.get(oldKey);
        String newKey = newPath.substring(newPath.lastIndexOf(46) + 1);
        newCmSection.put(newKey, movingValue);
        oldCmSection.set(oldKey, null);
    }

    @Override
    public void addComment(@NotNull String path, @NotNull String comment) {
        this.addComment(path, comment, true);
    }

    private void addComment(@NotNull String path, @NotNull String comment, boolean addPending) {
        Objects.requireNonNull(path, "The path cannot be null!");
        Objects.requireNonNull(comment, "The comment cannot be null!");
        if (this.getParent().isReloading()) {
            return;
        }
        if (addPending) {
            this.addPendingCommentsToPath(path);
        }
        if (this.getParent().getComments().containsKey(path)) {
            this.getParent().getComments().get(path).add(new Comment(comment));
        } else {
            this.getParent().getComments().put(this.getPathWithKey(path), new ArrayList<Comment>(Collections.singletonList(new Comment(comment))));
        }
    }

    @Override
    public void addComments(@NotNull String path, String ... comments) {
        Objects.requireNonNull(path, "The path cannot be null!");
        Objects.requireNonNull(comments, "The comments array cannot be null!");
        for (String comment : comments) {
            this.addComment(path, comment);
        }
    }

    @Override
    public void addExample(@NotNull String path, Object object) {
        this.addExample(path, object, null);
    }

    @Override
    public void addExample(@NotNull String path, Object object, @Nullable String comment) {
        Objects.requireNonNull(path, "The path cannot be null!");
        String[] sections = path.split("\\.");
        ArrayList<String> visited = new ArrayList<String>();
        for (String section : sections) {
            CMConfigSection parentSection;
            visited.add(section);
            String parentPath = String.join((CharSequence)".", visited);
            if (!this.getParent().getLenientSections().contains(parentPath) || (parentSection = (CMConfigSection)this.getSectionInternal(parentPath, false)) != null && parentSection.existingValues.get(section) != null) continue;
            this.forceExample(path, object, comment);
            return;
        }
        this.getParent().getExamples().add(this.getPathWithKey(path));
    }

    @Override
    public void createExampleSection(@NotNull String path) {
        Objects.requireNonNull(path, "The path cannot be null!");
        this.getParent().getExamples().add(this.getPathWithKey(path));
        CMMemorySection section = this.getSectionInternal(path);
        if (section == null) {
            this.createConfigSection(path);
        }
    }

    @Override
    public void forceExample(@NotNull String path, @Nullable Object value) {
        this.forceExample(path, value, null);
    }

    @Override
    public void forceExample(@NotNull String path, @Nullable Object value, @Nullable String comment) {
        Objects.requireNonNull(path, "The path cannot be null!");
        this.getParent().getExamples().add(this.getPathWithKey(path));
        this.addDefault(path, value, null, comment);
    }

    @Override
    public void makeSectionLenient(@NotNull String path) {
        Objects.requireNonNull(path, "The path cannot be null!");
        CMConfigSection section = (CMConfigSection)this.getSectionInternal(path + ".haha");
        if (section == null) {
            section = this.createSectionInternal(path + ".haha");
        }
        section.forceExistingIntoActual();
        if (this.getParent().getLenientSections().contains(this.getPathWithKey(path))) {
            return;
        }
        this.getParent().getLenientSections().add(this.getPathWithKey(path));
        CMConfigSection parent = (CMConfigSection)this.getSectionInternal(path);
        String key = this.getKey(path);
        if (parent != null) {
            parent.defaults.put(key, new CMConfigSection(parent.getPathWithKey(key), this.getParent()));
        }
        if (this.getParent().isReloading()) {
            return;
        }
        String fullPath = this.getPathWithKey(path);
        this.addPendingCommentsToPath(path);
        ArrayList comments = new ArrayList();
        if (this.getParent().getComments().containsKey(fullPath)) {
            comments.addAll(this.getParent().getComments().get(fullPath));
        }
        this.getParent().getPendingComments().clear();
        if (comments.size() > 0) {
            this.getParent().getComments().put(fullPath, comments);
        }
    }

    private void forceExistingIntoActual() {
        if (!this.getParent().isNew()) {
            this.clear();
        }
        for (String key : this.existingValues.keySet()) {
            if (this.existingValues.get(key) instanceof CMConfigSection) {
                ((CMConfigSection)this.existingValues.get(key)).forceExistingIntoActual();
            }
            this.put(key, this.existingValues.get(key));
        }
    }

    @Override
    public void addSection(@NotNull String section) {
        if (this.getParent().isReloading()) {
            return;
        }
        this.getParent().getPendingComments().add(new Section(section));
    }

    @Override
    public void addSection(@NotNull String path, @NotNull String section) {
        this.addSection(path, section, true);
    }

    private void addSection(@NotNull String path, @NotNull String section, boolean addPending) {
        Objects.requireNonNull(path, "The path cannot be null!");
        Objects.requireNonNull(section, "The section cannot be null!");
        if (this.getParent().isReloading()) {
            return;
        }
        if (addPending) {
            this.addPendingCommentsToPath(path);
        }
        if (this.getParent().getComments().containsKey(path)) {
            this.getParent().getComments().get(path).add(new Section(section));
        } else {
            this.getParent().getComments().put(this.getPathWithKey(path), new ArrayList<Section>(Collections.singletonList(new Section(section))));
        }
    }

    protected CMConfigSection createSectionInternal(@NotNull String path) {
        return this.createConfigSection(path.substring(0, path.lastIndexOf(46)));
    }

    @Override
    public CMConfigSection createConfigSection(@NotNull String path) {
        Objects.requireNonNull(path, "The path must not be null!");
        String[] sections = path.split("\\.");
        CMConfigSection toEdit = this;
        for (String section : sections) {
            Object option = toEdit.get(section);
            if (option == null) {
                option = new CMConfigSection(toEdit.getPath().length() == 0 ? section : toEdit.getPath() + "." + section, toEdit.getParent());
                toEdit.put(section, option);
                toEdit = (CMConfigSection)option;
                continue;
            }
            if (option instanceof CMConfigSection) {
                toEdit = (CMConfigSection)option;
                continue;
            }
            throw new IllegalStateException(path + " cannot be made into a configuration section due to already containing data!");
        }
        return toEdit;
    }

    protected Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String path : this.keySet()) {
            if (this.get(path) instanceof CMConfigSection) {
                map.put(path, ((CMConfigSection)this.get(path)).convertToMap());
                continue;
            }
            map.put(path, this.get(path));
        }
        return map;
    }

    protected void mapToCM(Map<?, ?> map) {
        for (Object keyObj : map.keySet()) {
            if (keyObj == null) {
                keyObj = "null";
            }
            String key = keyObj.toString();
            Object value = map.get(keyObj);
            if (value instanceof Map) {
                CMConfigSection section = new CMConfigSection(this.getPathWithKey(key), this.getParent());
                section.mapToCM((Map)value);
                this.existingValues.put(key, section);
                continue;
            }
            this.existingValues.put(key, value);
        }
    }

    protected String getParentPath(String path) {
        int finalIndex = path.lastIndexOf(46);
        if (finalIndex != -1) {
            return path.substring(0, finalIndex);
        }
        return null;
    }

    private String getPathWithKey(String key) {
        if (this.getPath().isEmpty()) {
            return key;
        }
        return this.getPath() + "." + key;
    }

    protected void addDefaults(HashMap<String, Object> map) {
        for (String key : this.keySet()) {
            if (this.get(key) instanceof CMConfigSection) {
                ((CMConfigSection)this.get(key)).addDefaults(map);
                continue;
            }
            map.put(this.getPathWithKey(key), this.defaults.get(key));
        }
        if (this.getParent().getLenientSections().contains(this.getPath()) && this.keySet().size() == 0) {
            map.put(this.getPath(), this);
        }
    }

    private void addPendingCommentsToPath(@NotNull String path) {
        int index = path.indexOf(46);
        String root = path.substring(0, index == -1 ? path.length() : index);
        for (Comment pendingComment : this.getParent().getPendingComments()) {
            if (pendingComment instanceof Section) {
                this.addSection(root, pendingComment.getComment(), false);
                continue;
            }
            this.addComment(root, pendingComment.getComment(), false);
        }
        this.getParent().getPendingComments().clear();
    }
}

