/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.libs.configmaster.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import me.xginko.aef.libs.configmaster.api.ConfigFile;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.configmaster.api.MemorySection;
import me.xginko.aef.libs.configmaster.impl.CMConfigSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMMemorySection
extends LinkedHashMap<String, Object>
implements MemorySection {
    protected LinkedHashMap<String, Object> defaults;
    protected LinkedHashMap<String, Object> existingValues;
    protected LinkedHashMap<String, Object> actualValues;
    protected String path;
    protected ConfigFile parent;

    CMMemorySection() {
        if (!(this instanceof ConfigFile)) {
            throw new IllegalStateException("SHUT UP. SHUT UP");
        }
        this.path = "";
        this.init();
    }

    CMMemorySection(String path, ConfigFile parent) {
        this.path = path;
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.defaults = new LinkedHashMap();
        this.existingValues = new LinkedHashMap();
    }

    @Override
    public String getString(@NotNull String path, @Nullable String defaultValue) {
        Object result = this.get(path, defaultValue);
        if (result == null) {
            return null;
        }
        return String.valueOf(result);
    }

    @Override
    public int getInteger(@NotNull String path, int defaultValue) {
        String result = this.getString(path);
        try {
            return result == null ? defaultValue : Integer.parseInt(result);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public double getDouble(@NotNull String path, double defaultValue) {
        String result = this.getString(path);
        try {
            return result == null ? defaultValue : Double.parseDouble(result);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public Object get(@NotNull String path, @Nullable Object defaultValue) {
        CMMemorySection section = this.getSectionInternal(path, false);
        if (section == null) {
            return defaultValue;
        }
        String key = this.getKey(path);
        return section.getOrDefault(key, section.existingValues.getOrDefault(key, defaultValue));
    }

    @Override
    public boolean getBoolean(@NotNull String path, boolean defaultValue) {
        String result = this.getString(path);
        if (result == null) {
            return defaultValue;
        }
        if (!result.equalsIgnoreCase("false") && !result.equalsIgnoreCase("true")) {
            return defaultValue;
        }
        return result.equalsIgnoreCase("true");
    }

    @Override
    public long getLong(@NotNull String path, long defaultValue) {
        String result = this.getString(path);
        try {
            return result == null ? defaultValue : Long.parseLong(result);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public short getShort(@NotNull String path, short defaultValue) {
        String result = this.getString(path);
        try {
            return result == null ? defaultValue : Short.parseShort(result);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public byte getByte(@NotNull String path, byte defaultValue) {
        String result = this.getString(path);
        try {
            return result == null ? defaultValue : Byte.parseByte(result);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(@NotNull String path, float defaultValue) {
        String result = this.getString(path);
        try {
            return result == null ? defaultValue : Float.parseFloat(result);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public ConfigSection getConfigSection(@NotNull String path, @Nullable ConfigSection defaultValue) {
        Object value = this.get(path, defaultValue);
        return value instanceof ConfigSection ? (ConfigSection)value : defaultValue;
    }

    @Override
    public boolean contains(@NotNull String path) {
        CMMemorySection section = this.getSectionInternal(path, false);
        if (section == null) {
            return false;
        }
        String key = this.getKey(path);
        return section.existingValues.containsKey(key) || section.containsKey(key);
    }

    @Override
    public <T> List<T> getList(@NotNull String path, @Nullable List<T> defaultValue) {
        List<Object> value = this.get(path, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        } else if (!(value instanceof List)) {
            value = new ArrayList<List<Object>>(Collections.singletonList(value));
        }
        return value;
    }

    @Override
    public void set(@NotNull String path, @Nullable Object object) {
        CMMemorySection section = this.getSectionInternal(path);
        if (section == null) {
            if (object == null) {
                return;
            }
            section = this.getParent().createSectionInternal(path);
        }
        String key = this.getKey(path);
        if (object == null) {
            section.remove(key);
            return;
        }
        section.put(key, object);
    }

    @Nullable
    protected CMMemorySection getSectionInternal(@NotNull String path) {
        return this.getSectionInternal(path, true);
    }

    protected CMMemorySection getSectionInternal(@NotNull String path, boolean add) {
        Objects.requireNonNull(path, "Path must not be null!");
        CMMemorySection section = this;
        while (path.indexOf(46) != -1 && section != null) {
            String key = path.substring(0, path.indexOf(46));
            path = path.substring(path.indexOf(46) + 1);
            CMMemorySection tempSection = section.existingValues.get(key) instanceof CMConfigSection ? (CMMemorySection)((Object)section.getConfigSection(key, (CMConfigSection)section.existingValues.get(key))) : (CMMemorySection)((Object)section.getConfigSection(key));
            if (tempSection != null && add) {
                section.putIfAbsent(key, tempSection);
            }
            section = tempSection;
        }
        return section;
    }

    @Override
    public List<String> getKeys(boolean deep, boolean useExisting) {
        ArrayList<String> keys = new ArrayList<String>();
        LinkedHashMap map = useExisting ? this.existingValues : this;
        for (String path : ((HashMap)map).keySet()) {
            if (deep && ((HashMap)map).get(path) instanceof CMConfigSection) {
                keys.addAll(((CMConfigSection)((HashMap)map).get(path)).getKeys(true));
                continue;
            }
            keys.add(path);
        }
        return keys;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected ConfigFile getParent() {
        return this instanceof ConfigFile ? (ConfigFile)this : this.parent;
    }

    protected String getKey(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }
}

