/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chat;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.CommandUtil;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.permissions.Permissible;

public class CommandAntiSpam
extends PacketModule {
    private final Map<String, Long> commandDelaySettings = new HashMap<String, Long>();
    private final int maxCommandLength = this.config.getInt(this.configPath + ".max-cmd-length", 256, "Any command exceeding this amount of chars will be blocked by default");
    private final long globalDelay;
    private final boolean useGlobalDelay = this.config.getBoolean(this.configPath + ".global-delay.enable", false, "Set this to true if you want a general delay on all commands.");
    private Map<UUID, Map<String, Long>> playerCommandCooldowns;

    public CommandAntiSpam() {
        super("chat.command-antispam", false, PacketListenerPriority.HIGHEST, "Adds a simple delay in between commands.\nBypass with permission: " + AEFPermission.BYPASS_CMD_SPAM.node());
        this.globalDelay = this.config.getLong(this.configPath + ".global-delay.delay-millis", 1000L, "The delay that will be used if the command isn't configured below");
        ConfigSection commandCooldowns = this.config.getConfigSection(this.configPath + ".commands", Map.of("suicide", 6000, "kill", 6000), "Format: commandlabel -> cooldown milliseconds");
        for (String commandLabel : commandCooldowns.getKeys(false)) {
            try {
                this.commandDelaySettings.put(commandLabel.toLowerCase(Locale.ROOT), Long.parseLong(commandCooldowns.getString(commandLabel)));
            }
            catch (NumberFormatException e) {
                this.warn("The value at '" + commandLabel + "' is not a valid long!");
            }
        }
    }

    @Override
    public void enable() {
        this.playerCommandCooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
    }

    @Override
    public void disable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
        if (this.playerCommandCooldowns != null) {
            this.playerCommandCooldowns.clear();
            this.playerCommandCooldowns = null;
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.CHAT_COMMAND || event.getPacketType() == PacketType.Play.Client.CHAT_COMMAND_UNSIGNED) {
            if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), AEFPermission.BYPASS_CMD_SPAM.node()).toBoolean()) {
                return;
            }
            if (this.shouldCancelCommand(event.getByteBuf(), event.getUser().getUUID())) {
                event.setCancelled(true);
            }
        }
    }

    private boolean shouldCancelCommand(Object byteBuffer, UUID playerUUID) {
        int strBufLength = ByteBufHelper.readVarInt((Object)byteBuffer);
        if (strBufLength < 0 || strBufLength > this.maxCommandLength * 4) {
            return true;
        }
        String command = ByteBufHelper.toString((Object)byteBuffer, (int)ByteBufHelper.readerIndex((Object)byteBuffer), (int)strBufLength, (Charset)StandardCharsets.UTF_8);
        ByteBufHelper.readerIndex((Object)byteBuffer, (int)(ByteBufHelper.readerIndex((Object)byteBuffer) + strBufLength));
        if (command.length() > this.maxCommandLength) {
            return true;
        }
        String commandLabel = CommandUtil.getCommandLabel(command).toLowerCase(Locale.ROOT);
        if (!this.useGlobalDelay && !this.commandDelaySettings.containsKey(commandLabel)) {
            return false;
        }
        Map commandCooldowns = this.playerCommandCooldowns.computeIfAbsent(playerUUID, uuid -> new HashMap());
        if (commandCooldowns.containsKey(commandLabel) && (Long)commandCooldowns.get(commandLabel) > System.currentTimeMillis()) {
            return true;
        }
        commandCooldowns.put(commandLabel, System.currentTimeMillis() + this.commandDelaySettings.getOrDefault(commandLabel, this.globalDelay));
        return false;
    }
}

