/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import com.destroystokyo.paper.MaterialTags;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.models.ChunkUID;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.plugin.Plugin;

public class DroppedItemLimit
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final Set<Material> whitelistedTypes;
    private final long checkPeriod;
    private final long cleanupDelayTicks;
    private final int maxDroppedItemsPerChunk;
    private final boolean logIsEnabled;
    private final boolean usingWhitelist;
    private final boolean onEntitiesLoad;
    private Cache<ChunkUID, ScheduledTask> scheduledChecks;
    private ScheduledTask scheduledTask;

    public DroppedItemLimit() {
        super("chunk-limits.entity-limits.dropped-item-limit", false, "Limit the amount of dropped items in a chunk to combat lag. \nBe aware this does not prioritize items by value or anything, \nit just deletes whatever happens to get over the limit during \ncounting.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", true);
        this.maxDroppedItemsPerChunk = this.config.getInt(this.configPath + ".max-dropped-items-per-chunk", 200);
        this.cleanupDelayTicks = Math.max(1, this.config.getInt(this.configPath + ".post-item-drop-check-delay-ticks", 60, "The delay in ticks the plugin will wait after an item in a chunk \nhas dropped before the check logic will run. \nThis improves performance as there will be no check for each single \nitem entity that spawns."));
        this.checkPeriod = this.config.getInt(this.configPath + ".check-period-in-ticks", 1200, "The period in ticks in which all loaded chunks should be regularly \nchecked. Keep in mind: A lower number provides more accuracy but is \nalso worse for performance.");
        this.onEntitiesLoad = this.config.getBoolean(this.configPath + ".check-on-entities-load", true, "Runs item check when a chunk's entities are loaded.");
        this.usingWhitelist = this.config.getBoolean(this.configPath + ".whitelist-specific-item-types", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-types", MaterialTags.SHULKER_BOXES.getValues().stream().map(Enum::name).sorted().toList(), "Check the paper api for correct Material enums: \nhttps://jd.papermc.io/paper/1.20.6/org/bukkit/Material.html \nMake sure your minecraft version is matching as well.").stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    public void enable() {
        this.scheduledChecks = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.cleanupDelayTicks * 50L)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
        if (this.scheduledChecks != null) {
            this.scheduledChecks.asMap().forEach((uid, task) -> task.cancel());
            this.scheduledChecks.invalidateAll();
            this.scheduledChecks.cleanUp();
            this.scheduledChecks = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onItemDrop(ItemSpawnEvent event) {
        Chunk chunk = event.getEntity().getChunk();
        this.scheduledChecks.get(ChunkUID.of(chunk), chunkUID -> this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, chunk.getWorld(), chunk.getX(), chunk.getZ(), chunkCheck -> {
            if (!chunk.isEntitiesLoaded()) {
                return;
            }
            int droppedItemCount = 0;
            for (Entity entity : chunk.getEntities()) {
                if (entity.getType() != XEntityType.ITEM.get() || ++droppedItemCount <= this.maxDroppedItemsPerChunk || this.usingWhitelist && this.whitelistedTypes.contains(((Item)entity).getItemStack().getType())) continue;
                entity.remove();
                if (!this.logIsEnabled) continue;
                this.info("Removed dropped item at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxDroppedItemsPerChunk);
            }
        }, this.cleanupDelayTicks));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntitiesLoad(EntitiesLoadEvent event) {
        if (!this.onEntitiesLoad) {
            return;
        }
        int droppedItemCount = 0;
        for (Entity entity : event.getEntities()) {
            if (entity.getType() != XEntityType.ITEM.get() || ++droppedItemCount <= this.maxDroppedItemsPerChunk || this.usingWhitelist && this.whitelistedTypes.contains(((Item)entity).getItemStack().getType())) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed dropped item at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxDroppedItemsPerChunk);
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    if (!chunk.isEntitiesLoaded()) {
                        return;
                    }
                    AtomicInteger droppedItemCount = new AtomicInteger();
                    for (Entity entity : chunk.getEntities()) {
                        entity.getScheduler().execute((Plugin)this.plugin, () -> {
                            if (entity.getType() != XEntityType.ITEM.get()) {
                                return;
                            }
                            if (droppedItemCount.incrementAndGet() <= this.maxDroppedItemsPerChunk) {
                                return;
                            }
                            if (this.usingWhitelist && this.whitelistedTypes.contains(((Item)entity).getItemStack().getType())) {
                                return;
                            }
                            entity.remove();
                            if (this.logIsEnabled) {
                                this.info("Removed dropped item at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxDroppedItemsPerChunk);
                            }
                        }, null, 1L);
                    }
                });
            }
        }
    }
}

