/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import java.time.Duration;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.models.ChunkUID;
import me.xginko.aef.utils.models.ExpiringSet;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;

public class FallingBlockLimit
extends AEFModule
implements Listener {
    private final long chunkCheckDelay;
    private final int maxFallingGravityBlockPerChunk;
    private final boolean logIsEnabled;
    private ExpiringSet<ChunkUID> checkedChunks;

    public FallingBlockLimit() {
        super("chunk-limits.falling-block-limit", true, "Prevent players from placing massive sand chunks, then collapsing \nthem to kill the server.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", false);
        this.maxFallingGravityBlockPerChunk = this.config.getInt(this.configPath + ".max-falling-gravity-blocks-per-chunk", 60, "Removes any falling block if there is more than x blocks actively \nfalling in a chunk.");
        this.chunkCheckDelay = (long)Math.max(1, this.config.getInt(this.configPath + ".chunk-check-delay-in-ticks", 20, "Delay in ticks until the same chunk can be checked again. \nPrevents overchecking, because physics events can be called many \ntimes in a short time for the same chunk.")) * 50L;
    }

    @Override
    public void enable() {
        this.checkedChunks = new ExpiringSet(Duration.ofMillis(this.chunkCheckDelay));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.checkedChunks != null) {
            this.checkedChunks.clear();
            this.checkedChunks.cleanUp();
            this.checkedChunks = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockPhysics(BlockPhysicsEvent event) {
        Chunk chunk = event.getBlock().getChunk();
        if (ChunkUtil.isRetrievalUnsafe(chunk)) {
            return;
        }
        ChunkUID chunkUID = ChunkUID.of(chunk);
        if (this.checkedChunks.contains(chunkUID)) {
            return;
        }
        int count = 0;
        boolean removed_falling = false;
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != XEntityType.FALLING_BLOCK.get() || ++count <= this.maxFallingGravityBlockPerChunk) continue;
            entity.remove();
            removed_falling = true;
        }
        this.checkedChunks.add(chunkUID);
        if (this.logIsEnabled && removed_falling) {
            this.info("Removed falling block(s) at " + LocationUtil.toString(event.getSourceBlock().getLocation()) + " because reached limit of " + this.maxFallingGravityBlockPerChunk + " falling gravity blocks per chunk");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChangeBlock(EntityChangeBlockEvent event) {
        if (event.getEntityType() != XEntityType.FALLING_BLOCK.get()) {
            return;
        }
        Chunk chunk = event.getBlock().getChunk();
        if (ChunkUtil.isRetrievalUnsafe(chunk)) {
            return;
        }
        ChunkUID chunkUID = ChunkUID.of(chunk);
        if (this.checkedChunks.contains(chunkUID)) {
            return;
        }
        int count = 0;
        boolean removed_falling = false;
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != XEntityType.FALLING_BLOCK.get() || ++count <= this.maxFallingGravityBlockPerChunk) continue;
            entity.remove();
            removed_falling = true;
        }
        this.checkedChunks.add(chunkUID);
        if (this.logIsEnabled && removed_falling) {
            this.info("Removed falling block(s) at " + LocationUtil.toString(event.getBlock().getLocation()) + " because reached limit of " + this.maxFallingGravityBlockPerChunk + " falling gravity blocks per chunk");
        }
    }
}

