/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;

public class MinecartLimit
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final long checkPeriod;
    private final int maxMinecartsPerChunk;
    private final boolean logIsEnabled;
    private ScheduledTask scheduledTask;

    public MinecartLimit() {
        super("chunk-limits.minecart-limit", false, "Limit the amount of minecarts to prevent lag caused by collisions.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", false);
        this.maxMinecartsPerChunk = this.config.getInt(this.configPath + ".max-minecarts-per-chunk", 25);
        this.checkPeriod = Math.max(1, this.config.getInt(this.configPath + ".check-period-in-ticks", 400));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onCreate(VehicleCreateEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!EntityUtil.MINECARTS.get().contains(vehicle.getType())) {
            return;
        }
        int minecartCount = 1;
        for (Entity entity : vehicle.getChunk().getEntities()) {
            if (!EntityUtil.MINECARTS.get().contains(entity.getType()) || ++minecartCount <= this.maxMinecartsPerChunk) continue;
            entity.getScheduler().execute((Plugin)this.plugin, () -> {
                entity.remove();
                if (this.logIsEnabled) {
                    this.info("Removed minecart " + String.valueOf(entity.getType()) + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxMinecartsPerChunk);
                }
            }, null, 1L);
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    if (!chunk.isEntitiesLoaded()) {
                        return;
                    }
                    AtomicInteger minecartCount = new AtomicInteger();
                    for (Entity entity : chunk.getEntities()) {
                        entity.getScheduler().execute((Plugin)this.plugin, () -> {
                            if (!EntityUtil.MINECARTS.get().contains(entity.getType()) || minecartCount.incrementAndGet() <= this.maxMinecartsPerChunk) {
                                return;
                            }
                            entity.remove();
                            if (this.logIsEnabled) {
                                this.info("Removed minecart " + String.valueOf(entity.getType()) + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxMinecartsPerChunk);
                            }
                        }, null, 1L);
                    }
                });
            }
        }
    }
}

