/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.plugin.Plugin;

public class NonLivingEntityLimit
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final long checkPeriod;
    private final int maxNonLivingEntities;
    private final boolean logIsEnabled;
    private ScheduledTask scheduledTask;

    public NonLivingEntityLimit() {
        super("chunk-limits.entity-limits.non-living-limit", false, "Limit the amount of non living entities in a chunk to prevent lag. \nIgnores dropped items.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", true);
        this.maxNonLivingEntities = this.config.getInt(this.configPath + ".max-non-living-per-chunk", 100);
        this.checkPeriod = Math.max(1, this.config.getInt(this.configPath + ".check-period-in-ticks", 20, "20 ticks = 1 second"));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onSpawn(EntitySpawnEvent event) {
        if (event.getEntityType() != XEntityType.ITEM.get() || EntityUtil.isLivingEntity(event.getEntity())) {
            return;
        }
        int nonLivingCount = 1;
        for (Entity entity : event.getEntity().getChunk().getEntities()) {
            if (entity.getType() != XEntityType.ITEM.get() || EntityUtil.isLivingEntity(entity) || ++nonLivingCount <= this.maxNonLivingEntities) continue;
            entity.remove();
            if (!this.logIsEnabled) continue;
            this.info("Removed non-living entity " + String.valueOf(entity.getType()) + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxNonLivingEntities);
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    if (!chunk.isEntitiesLoaded()) {
                        return;
                    }
                    AtomicInteger nonLivingCount = new AtomicInteger();
                    for (Entity entity : chunk.getEntities()) {
                        entity.getScheduler().execute((Plugin)this.plugin, () -> {
                            if (entity.getType() == XEntityType.ITEM.get()) {
                                return;
                            }
                            if (EntityUtil.isLivingEntity(entity)) {
                                return;
                            }
                            if (nonLivingCount.incrementAndGet() <= this.maxNonLivingEntities) {
                                return;
                            }
                            entity.remove();
                            if (this.logIsEnabled) {
                                this.info("Removed non-living entity " + String.valueOf(entity.getType()) + " at " + LocationUtil.toString(entity.getLocation()) + " because reached limit of " + this.maxNonLivingEntities);
                            }
                        }, null, 1L);
                    }
                });
            }
        }
    }
}

