/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.chunklimits;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class VillagerLimit
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final List<Villager.Profession> removalPriority;
    private final Set<Villager.Profession> professionWhitelist;
    private final long checkPeriod;
    private final int maxVillagersPerChunk;
    private final boolean logIsEnabled;
    private final boolean whitelistEnabled;
    private ScheduledTask scheduledTask;

    public VillagerLimit() {
        super("chunk-limits.entity-limits.villager-limit", false);
        this.maxVillagersPerChunk = Math.max(1, this.config.getInt(this.configPath + ".max-villagers-per-chunk", 25));
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", false);
        this.checkPeriod = Math.max(1, this.config.getInt(this.configPath + ".check-period-in-ticks", 600, "Check all chunks every x ticks."));
        List<String> defPriority = Stream.of("NONE", "NITWIT", "SHEPHERD", "FISHERMAN", "BUTCHER", "CARTOGRAPHER", "LEATHERWORKER", "FLETCHER", "MASON", "FARMER", "ARMORER", "TOOLSMITH", "WEAPONSMITH", "CLERIC", "LIBRARIAN").filter(prof -> {
            try {
                Villager.Profession.valueOf((String)prof);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }).collect(Collectors.toList());
        this.removalPriority = this.config.getList(this.configPath + ".removal-priority", defPriority, "Professions that are in the top of the list are going to be scheduled for \nremoval first.").stream().map(configuredProfession -> {
            try {
                return Villager.Profession.valueOf((String)configuredProfession);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Villager.Profession.class, (String)configuredProfession);
                return null;
            }
        }).filter(Objects::nonNull).toList();
        List<String> defWhitelist = Stream.of("NONE", "NITWIT", "SHEPHERD", "FISHERMAN", "BUTCHER", "CARTOGRAPHER", "LEATHERWORKER", "FLETCHER", "MASON", "FARMER", "ARMORER", "TOOLSMITH", "WEAPONSMITH", "CLERIC", "LIBRARIAN").filter(prof -> {
            try {
                Villager.Profession.valueOf((String)prof);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }).collect(Collectors.toList());
        this.whitelistEnabled = this.config.getBoolean(this.configPath + ".whitelist.enable", false);
        this.professionWhitelist = this.config.getList(this.configPath + ".whitelist.professions", defWhitelist).stream().map(configuredProfession -> {
            try {
                return Villager.Profession.valueOf((String)configuredProfession);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Villager.Profession.class, (String)configuredProfession);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getEntityType() == XEntityType.VILLAGER.get()) {
            this.checkVillagersInChunk(event.getEntity().getChunk());
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    if (chunk.isEntitiesLoaded()) {
                        this.checkVillagersInChunk(chunk);
                    }
                });
            }
        }
    }

    private void checkVillagersInChunk(Chunk chunk) {
        Entity[] entities = chunk.getEntities();
        if (entities.length <= this.maxVillagersPerChunk) {
            return;
        }
        ArrayList<Villager> villagers_in_chunk = new ArrayList<Villager>();
        for (Entity entity : entities) {
            if (entity.getType() != XEntityType.VILLAGER.get()) continue;
            Villager villager2 = (Villager)entity;
            if (!this.whitelistEnabled || this.professionWhitelist.contains(villager2.getProfession())) continue;
            villagers_in_chunk.add(villager2);
        }
        int amount_over_the_limit = villagers_in_chunk.size() - this.maxVillagersPerChunk;
        if (amount_over_the_limit <= 0) {
            return;
        }
        villagers_in_chunk.sort(Comparator.comparingInt(villager -> {
            Villager.Profession profession = villager.getProfession();
            return this.removalPriority.contains(profession) ? this.removalPriority.indexOf(profession) : Integer.MAX_VALUE;
        }));
        for (int i = 0; i < amount_over_the_limit; ++i) {
            Villager villager3 = (Villager)villagers_in_chunk.get(i);
            villager3.getScheduler().execute((Plugin)this.plugin, () -> {
                villager3.remove();
                if (this.logIsEnabled) {
                    this.info("Removed villager with profession '" + String.valueOf(villager3.getProfession()) + "' at " + LocationUtil.toString(villager3.getLocation()));
                }
            }, null, 1L);
        }
    }
}

