/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.XTag;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.MaterialUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class Burrow
extends AEFModule
implements Listener {
    private final Set<Material> ignoredMaterial;
    private final double damageWhenMovingInBurrow;
    private final boolean shouldTeleportUp;
    private final boolean preventIfBlockAboveBurrow;
    private final boolean breakAnvilInsteadOfTP;
    private final boolean allowSlabs;

    public Burrow() {
        super("combat.prevent-burrow", false);
        this.damageWhenMovingInBurrow = this.config.getDouble(this.configPath + ".damage-when-moving", 1.0, "1.0 = Half a heart of damage every time you move.");
        this.shouldTeleportUp = this.config.getBoolean(this.configPath + ".teleport-above-block", true);
        this.preventIfBlockAboveBurrow = this.config.getBoolean(this.configPath + ".prevent-if-block-above-burrow", false, "Prevent burrow even if there is a block above the block they \nare burrowing in. \nPlease note this may allow creating an \"elevator\", players will \nkeep teleporting up until they hit air.");
        this.breakAnvilInsteadOfTP = this.config.getBoolean(this.configPath + ".break-anvil-instead-of-teleport", true);
        this.allowSlabs = this.config.getBoolean(this.configPath + ".allow-slabs-in-burrow", true, "Needs to be enabled to prevent a bug where players are teleported \nabove a slab when the slab is underwater.");
        List<String> defaults = Stream.concat(XTag.SHULKER_BOXES.getValues().stream(), Stream.of(XMaterial.AIR, XMaterial.DIRT, XMaterial.DIRT_PATH, XMaterial.SAND, XMaterial.GRAVEL)).filter(XBase::isSupported).map(XMaterial::get).map(Enum::name).toList();
        this.ignoredMaterial = this.config.getList(this.configPath + ".ignored-materials", defaults).stream().map(ignored -> {
            try {
                return Material.valueOf((String)ignored);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)ignored);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    private void teleportUpAndCenter(Player player, Location from) {
        player.teleportAsync(from.clone().add(0.5, 1.0, 0.5));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onSelfPlace(BlockPlaceEvent event) {
        Location blockLoc = event.getBlock().getLocation();
        Location legsLoc = event.getPlayer().getLocation().toBlockLocation();
        if (legsLoc.equals((Object)blockLoc) || legsLoc.add(0.0, 1.0, 0.0).equals((Object)blockLoc)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (player.isInsideVehicle() || player.isGliding() || player.isSwimming()) {
            return;
        }
        Location playerLocation = player.getLocation();
        Block burrowBlock = playerLocation.getBlock();
        if (this.ignoredMaterial.contains(burrowBlock.getType())) {
            return;
        }
        if (!this.preventIfBlockAboveBurrow && !burrowBlock.getRelative(BlockFace.UP).getType().isAir()) {
            return;
        }
        if (MaterialUtil.SOLID_INDESTRUCTIBLES.get().contains(burrowBlock.getType()) || burrowBlock.getType() == XMaterial.BEACON.get()) {
            player.damage(this.damageWhenMovingInBurrow);
            if (this.shouldTeleportUp) {
                this.teleportUpAndCenter(player, burrowBlock.getLocation());
            }
            return;
        }
        if (burrowBlock.getType().isOccluding() && !MaterialUtil.SINK_IN_BLOCKS.get().contains(burrowBlock.getType())) {
            if (!this.allowSlabs || !MaterialUtil.SLAB_LIKE.get().contains(burrowBlock.getType())) {
                player.damage(this.damageWhenMovingInBurrow);
                if (this.shouldTeleportUp) {
                    this.teleportUpAndCenter(player, burrowBlock.getLocation());
                }
            }
            return;
        }
        if (MaterialUtil.ANVILS.get().contains(burrowBlock.getType())) {
            player.damage(this.damageWhenMovingInBurrow);
            if (this.breakAnvilInsteadOfTP) {
                burrowBlock.setType(XMaterial.AIR.get());
            } else if (this.shouldTeleportUp) {
                this.teleportUpAndCenter(player, burrowBlock.getLocation());
            }
            return;
        }
        if (burrowBlock.getType() == XMaterial.ENDER_CHEST.get() || MaterialUtil.SINK_IN_BLOCKS.get().contains(burrowBlock.getType())) {
            if (playerLocation.getY() - (double)playerLocation.getBlockY() < 0.875) {
                player.damage(this.damageWhenMovingInBurrow);
                if (this.shouldTeleportUp) {
                    this.teleportUpAndCenter(player, burrowBlock.getLocation());
                }
            }
            return;
        }
        if (burrowBlock.getType() == XMaterial.ENCHANTING_TABLE.get() && playerLocation.getY() - (double)playerLocation.getBlockY() < 0.75) {
            player.damage(this.damageWhenMovingInBurrow);
            if (this.shouldTeleportUp) {
                this.teleportUpAndCenter(player, burrowBlock.getLocation());
            }
        }
    }
}

