/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.plugin.Plugin;

public class PistonCrystalDelay
extends AEFModule
implements Listener {
    private final long cooldownNanos;
    private Map<Location, Long> extendCooldowns;

    public PistonCrystalDelay() {
        super("combat.crystal-aura.piston-aura-delay", false, "Rate-limits pistons that extend into crystals.");
        this.cooldownNanos = TimeUnit.MILLISECONDS.toNanos((long)Math.max(1, this.config.getInt(this.configPath + ".piston-extend-delay-in-ticks", 40)) * 50L);
    }

    @Override
    public void enable() {
        this.extendCooldowns = new ConcurrentHashMap<Location, Long>();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.extendCooldowns != null) {
            this.extendCooldowns.clear();
            this.extendCooldowns = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPistonExtend(BlockPistonExtendEvent event) {
        for (Entity entity : event.getBlock().getRelative(event.getDirection()).getLocation().getNearbyEntities(1.0, 1.0, 1.0)) {
            if (entity.getType() != XEntityType.END_CRYSTAL.get()) continue;
            if (this.extendCooldowns.containsKey(event.getBlock().getLocation()) && this.extendCooldowns.get(event.getBlock().getLocation()) > System.nanoTime()) {
                event.setCancelled(true);
            } else {
                this.extendCooldowns.put(event.getBlock().getLocation(), System.currentTimeMillis() + this.cooldownNanos);
            }
            return;
        }
    }
}

