/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.plugin.Plugin;

public class PistonPush
extends AEFModule
implements Listener {
    private final Set<EntityType> pushDisabledTypes;

    public PistonPush() {
        super("combat.piston-push", false, "Disables pistons from extending if it would push certain configured entities.\nThis can be used to prevent players from pushing other players out of burrows, by\nconfiguring PLAYER, or to disable piston-crystal by adding ENDER_CRYSTAL to the list.");
        this.pushDisabledTypes = this.config.getList(this.configPath + ".piston-push-blocked-entities", Collections.singletonList("PLAYER")).stream().map(configuredType -> {
            try {
                return EntityType.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class)));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPistonExtend(BlockPistonExtendEvent event) {
        for (Entity entity : event.getBlock().getRelative(event.getDirection()).getLocation().getNearbyEntities(1.0, 1.0, 1.0)) {
            if (!this.pushDisabledTypes.contains(entity.getType())) continue;
            event.setCancelled(true);
            return;
        }
    }
}

