/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientTeleportConfirm;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerPositionAndLook;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.xginko.aef.modules.packets.PacketModule;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PortalGodMode
extends PacketModule
implements Listener {
    private final long timeoutMillis;
    private final boolean kickPlayer;
    private final boolean log;
    private Map<UUID, ConfirmTimeout> timeoutMap;

    public PortalGodMode() {
        super("combat.portal-god-mode-patch", false, PacketListenerPriority.MONITOR, "Prevents an exploit that allows players to stand in nether portals and not \ntake damage indefinitely by just never sending a TeleportConfirm packet to \nthe server. \nA similar method is used for the chorus tp exploit.");
        this.log = this.config.getBoolean(this.configPath + ".log", true);
        this.kickPlayer = this.config.getBoolean(this.configPath + ".kick-player", true, "If set to false, will simulate a TeleportConfirm packet to the server.");
        this.timeoutMillis = this.config.getLong(this.configPath + ".client-wait-millis", 2000L, "How many millis to wait for the client to respond with a TeleportConfirm \npacket before we simulate it.");
    }

    @Override
    public void enable() {
        this.timeoutMap = new ConcurrentHashMap<UUID, ConfirmTimeout>(Math.max(16, this.plugin.getServer().getOnlinePlayers().size()));
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
        if (this.timeoutMap != null) {
            this.timeoutMap.forEach((uuid, timeout) -> timeout.task.cancel());
            this.timeoutMap.clear();
            this.timeoutMap = null;
        }
    }

    public void onPacketSend(@NotNull PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.PLAYER_POSITION_AND_LOOK) {
            return;
        }
        if (this.timeoutMap.containsKey(event.getUser().getUUID())) {
            this.timeoutMap.get((Object)event.getUser().getUUID()).task.cancel();
        }
        this.timeoutMap.put(event.getUser().getUUID(), new ConfirmTimeout(this, event.getUser(), new WrapperPlayServerPlayerPositionAndLook(event).getTeleportId()));
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.TELEPORT_CONFIRM && this.timeoutMap.containsKey(event.getUser().getUUID()) && new WrapperPlayClientTeleportConfirm(event).getTeleportId() == this.timeoutMap.get((Object)event.getUser().getUUID()).teleportId) {
            this.timeoutMap.remove((Object)event.getUser().getUUID()).task.cancel();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerQuit(PlayerQuitEvent event) {
        if (this.timeoutMap.containsKey(event.getPlayer().getUniqueId())) {
            this.timeoutMap.remove((Object)event.getPlayer().getUniqueId()).task.cancel();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerKick(PlayerKickEvent event) {
        if (this.timeoutMap.containsKey(event.getPlayer().getUniqueId())) {
            this.timeoutMap.remove((Object)event.getPlayer().getUniqueId()).task.cancel();
        }
    }

    private static class ConfirmTimeout
    implements Consumer<ScheduledTask> {
        private final PortalGodMode module;
        private final User user;
        private final int teleportId;
        private final ScheduledTask task;

        private ConfirmTimeout(PortalGodMode module, User user, int teleportId) {
            this.module = module;
            this.user = user;
            this.teleportId = teleportId;
            this.task = module.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)module.plugin, (Consumer)this, module.timeoutMillis, TimeUnit.MILLISECONDS);
        }

        @Override
        public void accept(ScheduledTask scheduledTask) {
            if (this.user == null) {
                return;
            }
            if (this.module.log) {
                this.module.warn("Player " + this.user.getName() + " either lagging or hacking. No TeleportConfirm in " + this.module.timeoutMillis + "ms!");
            }
            if (this.module.kickPlayer) {
                if (this.module.log) {
                    this.module.warn("Disconnecting " + this.user.getName() + ".");
                }
                this.user.closeConnection();
            } else {
                if (this.module.log) {
                    this.module.warn("Simulating a TeleportConfirm response from " + this.user.getName() + ".");
                }
                this.user.receivePacketSilently((PacketWrapper)new WrapperPlayClientTeleportConfirm(this.teleportId));
            }
        }
    }
}

