/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class SilentSwapDelay
extends AEFModule
implements Listener {
    private final long cooldownNanos;
    private final boolean updateInventory;
    private Map<UUID, Long> swapItemCooldowns;

    public SilentSwapDelay() {
        super("combat.silent-swap-delay", false);
        this.updateInventory = this.config.getBoolean(this.configPath + ".update-inventory-on-cancel", false, "Can help with desync but recommended to leave off unless you have issues.");
        this.cooldownNanos = TimeUnit.MILLISECONDS.toNanos(this.config.getLong(this.configPath + ".min-swap-delay-millis", 40L, "The delay in millis a player cant swap hotbar items after placing\na block, clicking a block (for example to place a crystal) or\ndamaging an entity. (50 ms = 1 tick)"));
    }

    @Override
    public void enable() {
        this.swapItemCooldowns = new ConcurrentHashMap<UUID, Long>();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.swapItemCooldowns != null) {
            this.swapItemCooldowns.clear();
            this.swapItemCooldowns = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerItemHeld(PlayerItemHeldEvent event) {
        if (!this.swapItemCooldowns.containsKey(event.getPlayer().getUniqueId())) {
            return;
        }
        if (this.swapItemCooldowns.get(event.getPlayer().getUniqueId()) > System.nanoTime()) {
            event.setCancelled(true);
            if (this.updateInventory) {
                event.getPlayer().updateInventory();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onInventoryInteract(InventoryInteractEvent event) {
        if (!this.swapItemCooldowns.containsKey(event.getWhoClicked().getUniqueId())) {
            return;
        }
        if (this.swapItemCooldowns.get(event.getWhoClicked().getUniqueId()) > System.nanoTime()) {
            event.setCancelled(true);
            if (this.updateInventory) {
                ((Player)event.getWhoClicked()).updateInventory();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() == XEntityType.PLAYER.get()) {
            this.swapItemCooldowns.put(event.getDamager().getUniqueId(), System.nanoTime() + this.cooldownNanos);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerInteract(PlayerInteractEvent event) {
        this.swapItemCooldowns.put(event.getPlayer().getUniqueId(), System.nanoTime() + this.cooldownNanos);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onBlockPlace(BlockPlaceEvent event) {
        this.swapItemCooldowns.put(event.getPlayer().getUniqueId(), System.nanoTime() + this.cooldownNanos);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerQuit(PlayerQuitEvent event) {
        this.swapItemCooldowns.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerKick(PlayerKickEvent event) {
        this.swapItemCooldowns.remove(event.getPlayer().getUniqueId());
    }
}

