/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.combat.auras;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public abstract class AuraDelayModule
extends AEFModule
implements Listener {
    protected final Map<SettingType, Cooldowns> cooldownSettings = new EnumMap<SettingType, Cooldowns>(SettingType.class);
    protected final boolean updateInventory;

    public AuraDelayModule(String configPath, long defPlaceDelayMillis, long defBreakDelayMillis) {
        this(configPath, false, defPlaceDelayMillis, defBreakDelayMillis);
    }

    public AuraDelayModule(String configPath, boolean defEnabled, long defPlaceDelayMillis, long defBreakDelayMillis) {
        super(configPath, defEnabled);
        this.updateInventory = this.config.getBoolean(configPath + ".update-inventory-on-cancel", false, "Can help with desync but recommended to leave off unless you have issues.");
        for (SettingType settingType : SettingType.values()) {
            String typePath = configPath + "." + settingType.name().toLowerCase().replace("_", "-");
            boolean enabled = this.config.getBoolean(typePath + ".enable", false);
            Cooldowns cooldowns = new Cooldowns(this.config.getLong(typePath + ".place-delay-millis", defPlaceDelayMillis, "1 tick = 50 ms"), this.config.getLong(typePath + ".break-delay-millis", defBreakDelayMillis));
            if (!enabled) continue;
            this.cooldownSettings.put(settingType, cooldowns);
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.cooldownSettings.forEach((settingType, cooldowns) -> cooldowns.clear());
    }

    protected boolean isOnCooldown(UUID uuid, Map<UUID, Long> cooldownMap, long delayNanos) {
        if (delayNanos <= 0L) {
            return false;
        }
        if (cooldownMap.containsKey(uuid) && cooldownMap.get(uuid) > System.nanoTime()) {
            return true;
        }
        cooldownMap.put(uuid, System.nanoTime() + delayNanos);
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.cooldownSettings.forEach((settingType, cooldowns) -> {
            cooldowns.placeCooldowns.remove(event.getPlayer().getUniqueId());
            cooldowns.breakCooldowns.remove(event.getPlayer().getUniqueId());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        this.cooldownSettings.forEach((settingType, cooldowns) -> {
            cooldowns.placeCooldowns.remove(event.getPlayer().getUniqueId());
            cooldowns.breakCooldowns.remove(event.getPlayer().getUniqueId());
        });
    }

    protected static enum SettingType {
        GLOBAL(EquipmentSlot.HEAD),
        MAIN_HAND(EquipmentSlot.HAND),
        OFF_HAND(EquipmentSlot.OFF_HAND);

        public final EquipmentSlot slot;

        private SettingType(EquipmentSlot slot) {
            this.slot = slot;
        }
    }

    protected static class Cooldowns {
        public Map<UUID, Long> placeCooldowns = new ConcurrentHashMap<UUID, Long>();
        public Map<UUID, Long> breakCooldowns = new ConcurrentHashMap<UUID, Long>();
        public final long placeDelayNanos;
        public final long breakDelayNanos;

        public Cooldowns(long placeDelayMillis, long breakDelayMillis) {
            this.placeDelayNanos = TimeUnit.MILLISECONDS.toNanos(placeDelayMillis);
            this.breakDelayNanos = TimeUnit.MILLISECONDS.toNanos(breakDelayMillis);
        }

        public void clear() {
            this.placeCooldowns.clear();
            this.breakCooldowns.clear();
            this.breakCooldowns = null;
            this.placeCooldowns = null;
        }
    }
}

