/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.models.ExpiringSet;

public class BookTitleDupe
extends PacketModule {
    private final long cooldownMillis;
    private final int titleLimit;
    private final int pageLimit;
    private final int pageCharLimit;
    private final boolean log;
    private final boolean kick;
    private ExpiringSet<UUID> editCooldown;

    public BookTitleDupe() {
        super("dupe-preventions.book-title-dupe", Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_6) && !Platform.getServerVersion().isOlderThan(ServerVersion.V_1_21_2), PacketListenerPriority.HIGHEST, "Relevant for 1.20.6 - 1.21:\nWill prevent players from sending book packets with a too large title,\nto get disconnected and their inventories restored.");
        boolean modernLimits = Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2);
        this.titleLimit = this.config.getInt(this.configPath + ".max-title-charlength", modernLimits ? 15 : 120);
        this.pageLimit = this.config.getInt(this.configPath + ".max-pages", modernLimits ? 90 : 190);
        this.pageCharLimit = this.config.getInt(this.configPath + ".max-page-charlength", modernLimits ? 1000 : 8100);
        this.cooldownMillis = this.config.getLong(this.configPath + ".spam-cooldown-millis", 1000L);
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    @Override
    public void enable() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
        this.editCooldown = new ExpiringSet(Duration.ofMillis(this.cooldownMillis));
    }

    @Override
    public void disable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
        if (this.editCooldown != null) {
            this.editCooldown.clear();
            this.editCooldown.cleanUp();
            this.editCooldown = null;
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled() || event.getPacketType() != PacketType.Play.Client.EDIT_BOOK) {
            return;
        }
        if (this.editCooldown.contains(event.getUser().getUUID())) {
            event.setCancelled(true);
            if (this.log) {
                this.info(event.getUser().getName() + " tried to edit book too quickly.");
            }
            return;
        }
        this.editCooldown.add(event.getUser().getUUID());
        if (this.isIllegalBookEdit(event)) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
        }
    }

    private boolean isIllegalBookEdit(PacketReceiveEvent event) {
        int slot = ByteBufHelper.readVarInt((Object)event.getByteBuf());
        int pageCount = ByteBufHelper.readVarInt((Object)event.getByteBuf());
        if (pageCount > this.pageLimit) {
            return true;
        }
        for (int i = 0; i < pageCount; ++i) {
            if (!this.isStringTooBig(event.getByteBuf(), this.pageCharLimit)) continue;
            return true;
        }
        if (ByteBufHelper.readByte((Object)event.getByteBuf()) != 0) {
            return this.isStringTooBig(event.getByteBuf(), this.titleLimit);
        }
        return false;
    }

    private boolean isStringTooBig(Object byteBuf, int charLimit) {
        int strBufLen = ByteBufHelper.readVarInt((Object)byteBuf);
        if (strBufLen < 0 || strBufLen > charLimit * 4) {
            return true;
        }
        return ByteBufHelper.toString((Object)byteBuf, (int)ByteBufHelper.readerIndex((Object)byteBuf), (int)strBufLen, (Charset)StandardCharsets.UTF_8).length() > charLimit;
    }
}

