/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.EntityUtil;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.plugin.Plugin;

public class ChestsOnEntities
extends AEFModule
implements Listener {
    public ChestsOnEntities() {
        super("dupe-preventions.prevent-chests-on-living-entities", false, "Prevent any possible dupes involving chested entities by making \nit impossible to put a chest on them. \nOnly do this if you have reason to believe a dupe like that exists \non your server.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerInteract(PlayerInteractAtEntityEvent event) {
        if (!EntityUtil.isChestableHorse(event.getRightClicked())) {
            return;
        }
        event.setCancelled(true);
        ChestedHorse chestedHorse = (ChestedHorse)event.getRightClicked();
        chestedHorse.getScheduler().execute((Plugin)this.plugin, () -> {
            if (chestedHorse.isCarryingChest()) {
                chestedHorse.setCarryingChest(false);
            }
        }, null, 2L);
    }
}

