/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.dupepreventions;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.enums.Platform;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;

public class TridentDupe
extends AEFModule
implements Listener {
    private final Set<Material> dupePreventedMaterial;

    public TridentDupe() {
        super("dupe-preventions.trident-dupe", Platform.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_21_4), "Prevents trident dupe from working in 1.13 - 1.21.4\nThis dupe was originally found by Autism inc and turned into\na mod by Killet, Laztec, and Ionar.");
        this.dupePreventedMaterial = this.config.getList(this.configPath + ".materials", Stream.of(XMaterial.TRIDENT, XMaterial.ARROW, XMaterial.TIPPED_ARROW, XMaterial.SPECTRAL_ARROW, XMaterial.EGG, XMaterial.WIND_CHARGE).filter(XBase::isSupported).map(XMaterial::get).map(Enum::name).collect(Collectors.toList()), "Apply the check for relevant materials only to not break features like alt silent swap.\nIf you do not wish to check for specific materials, leave this list empty.").stream().map(configuredMaterial -> {
            try {
                return Material.valueOf((String)configuredMaterial);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredMaterial);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onInventoryClick(InventoryClickEvent event) {
        if (this.dupePreventedMaterial.contains(event.getWhoClicked().getActiveItem().getType())) {
            event.setCancelled(true);
        } else if (this.dupePreventedMaterial.isEmpty() && event.getWhoClicked().getActiveItem().getType() != XMaterial.AIR.get()) {
            event.setCancelled(true);
        }
    }
}

