/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.elytra;

import java.util.Locale;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.config.Translation;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.modules.elytra.ElytraHelper;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.permissions.AEFPermission;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class ElytraAtSpawn
extends AEFModule
implements Listener {
    private final double spawn_SpeedOldChunks;
    private final double spawn_SpeedNewChunks;
    private final double spawn_DenyElytraTPS;
    private final boolean spawn_DenyElytra;
    private final boolean spawn_DenyOnLowTPS;
    private final boolean spawn_AlsoRemoveElytraOnLowTPS;

    public ElytraAtSpawn() {
        super("elytra.elytra-speed.At-Spawn", false, "Use separate values for players at spawn.");
        this.spawn_DenyElytra = this.config.getBoolean(this.configPath + ".deny-elytra-usage", false);
        this.spawn_SpeedOldChunks = this.config.getDouble(this.configPath + ".speed-old-chunks", 1.0);
        this.spawn_SpeedNewChunks = this.config.getDouble(this.configPath + ".speed-new-chunks", 0.8);
        this.spawn_DenyOnLowTPS = this.config.getBoolean(this.configPath + ".deny-elytra-on-low-TPS", true);
        this.spawn_DenyElytraTPS = this.config.getDouble(this.configPath + ".deny-elytra-TPS", 10.0);
        this.spawn_AlsoRemoveElytraOnLowTPS = this.config.getBoolean(this.configPath + ".also-remove-elytra-on-low-TPS", true);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public boolean shouldEnable() {
        return this.config.elytra_enable_at_spawn;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.isGliding()) {
            return;
        }
        if (!event.hasExplicitlyChangedPosition()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)player, AEFPermission.BYPASS_ELYTRA.node()).toBoolean()) {
            return;
        }
        Location playerLoc = player.getLocation();
        if (this.config.elytra_enable_netherceiling && ElytraHelper.isNetherCeiling(playerLoc)) {
            return;
        }
        if (LocationUtil.getSquaredDistance2DTo00(playerLoc) > this.config.elytra_spawn_radius_squared) {
            return;
        }
        if (this.spawn_DenyElytra) {
            if (this.config.elytra_teleport_back) {
                player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
            if (this.config.elytra_actionbar_enabled) {
                player.sendActionBar(AnarchyExploitFixes.translation((Locale)player.locale()).elytra_spawn_DisabledHere.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%radius%").replacement(String.valueOf(this.config.elytra_spawn_radius)).build()));
            }
            return;
        }
        if (this.spawn_DenyOnLowTPS && AnarchyExploitFixes.tickReporter().getTPS() <= this.spawn_DenyElytraTPS) {
            if (this.config.elytra_teleport_back) {
                player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
            }
            if (this.config.elytra_actionbar_enabled) {
                player.sendActionBar(AnarchyExploitFixes.translation((Locale)player.locale()).elytra_spawn_DisabledLowTPS.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%tps%").replacement(String.valueOf(this.spawn_DenyElytraTPS)).build()));
            }
            if (this.spawn_AlsoRemoveElytraOnLowTPS) {
                player.getScheduler().execute((Plugin)this.plugin, () -> {
                    PlayerInventory playerInv = player.getInventory();
                    if (MaterialUtil.isElytra(playerInv.getChestplate())) {
                        ItemStack elytra = playerInv.getChestplate();
                        playerInv.setChestplate(null);
                        player.getWorld().dropItemNaturally(playerLoc, elytra);
                    }
                }, null, 1L);
            }
            return;
        }
        double flySpeed = ElytraHelper.getInstance().getBlocksPerTick(event);
        if (ElytraHelper.getInstance().isInNewChunks(player)) {
            if (flySpeed > this.spawn_SpeedNewChunks) {
                if (this.config.elytra_teleport_back) {
                    player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
                } else {
                    event.setCancelled(true);
                }
                if (this.config.elytra_play_too_fast_sound) {
                    player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                }
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.locale());
                if (this.config.elytra_show_chunkage) {
                    player.sendActionBar(lang.elytra_spawn_TooFastChunkInfo.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_spawn_New).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_spawn_Chunks).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%radius%").replacement(String.valueOf(this.config.elytra_spawn_radius_squared)).build()));
                } else {
                    player.sendActionBar(lang.elytra_spawn_TooFast.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%radius%").replacement(String.valueOf(this.config.elytra_spawn_radius_squared)).build()));
                }
            } else {
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.locale());
                if (this.config.elytra_show_chunkage) {
                    player.sendActionBar(lang.elytra_spawn_YouAreFlyingIn.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_spawn_New_UpperCase).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_spawn_Chunks).build()).append((Component)Component.space()).append(lang.elytra_spawn_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.spawn_SpeedNewChunks)).build())));
                } else {
                    player.sendActionBar(lang.elytra_spawn_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.spawn_SpeedNewChunks)).build()));
                }
            }
        } else if (flySpeed > this.spawn_SpeedOldChunks) {
            if (this.config.elytra_teleport_back) {
                player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
            if (!this.config.elytra_actionbar_enabled) {
                return;
            }
            Translation lang = AnarchyExploitFixes.translation(player.locale());
            if (this.config.elytra_show_chunkage) {
                player.sendActionBar(lang.elytra_spawn_TooFastChunkInfo.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_spawn_Old).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_spawn_Chunks).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%radius%").replacement(String.valueOf(this.config.elytra_spawn_radius_squared)).build()));
            } else {
                player.sendActionBar(lang.elytra_spawn_TooFast.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%radius%").replacement(String.valueOf(this.config.elytra_spawn_radius_squared)).build()));
            }
        } else {
            if (!this.config.elytra_actionbar_enabled) {
                return;
            }
            Translation lang = AnarchyExploitFixes.translation(player.locale());
            if (this.config.elytra_show_chunkage) {
                player.sendActionBar(lang.elytra_spawn_YouAreFlyingIn.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_spawn_Old_UpperCase).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_spawn_Chunks).build()).append((Component)Component.space()).append(lang.elytra_spawn_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.spawn_SpeedOldChunks)).build())));
            } else {
                player.sendActionBar(lang.elytra_spawn_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.spawn_SpeedOldChunks)).build()));
            }
        }
    }
}

