/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.elytra;

import java.util.Locale;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.config.Translation;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.modules.elytra.ElytraHelper;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.permissions.AEFPermission;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class ElytraGlobal
extends AEFModule
implements Listener {
    private final double global_SpeedOldChunks;
    private final double global_SpeedNewChunks;
    private final double global_BurstSpeedOldChunks;
    private final double global_BurstSpeedNewChunks;
    private final double global_BurstOldChunk_TPS;
    private final double global_BurstNewChunk_TPS;
    private final double global_DenyElytraTPS;
    private final boolean global_DenyElytra;
    private final boolean global_EnableBursting;
    private final boolean global_DenyOnLowTPS;
    private final boolean global_AlsoRemoveOnLowTPS;

    public ElytraGlobal() {
        super("elytra.elytra-speed.Global-Settings", false, "Global settings. If nothing else is enabled, this will be used for all environments.");
        this.global_DenyElytra = this.config.getBoolean(this.configPath + ".deny-elytra-usage", false);
        this.global_SpeedOldChunks = this.config.getDouble(this.configPath + ".speed-old-chunks", 1.81);
        this.global_SpeedNewChunks = this.config.getDouble(this.configPath + ".speed-new-chunks", 1.81);
        this.global_EnableBursting = this.config.getBoolean(this.configPath + ".enable-bursting", true);
        this.global_BurstSpeedOldChunks = this.config.getDouble(this.configPath + ".burst-speed-old-chunks", 5.0);
        this.global_BurstOldChunk_TPS = this.config.getDouble(this.configPath + ".burst-speed-old-chunk-TPS", 18.0);
        this.global_BurstSpeedNewChunks = this.config.getDouble(this.configPath + ".burst-speed-new-chunks", 3.12);
        this.global_BurstNewChunk_TPS = this.config.getDouble(this.configPath + ".burst-speed-new-chunk-TPS", 19.0);
        this.global_DenyOnLowTPS = this.config.getBoolean(this.configPath + ".deny-elytra-on-low-TPS", true);
        this.global_DenyElytraTPS = this.config.getDouble(this.configPath + ".deny-elytra-TPS", 12.0);
        this.global_AlsoRemoveOnLowTPS = this.config.getBoolean(this.configPath + ".also-remove-elytra-on-low-TPS", true);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.isGliding()) {
            return;
        }
        if (!event.hasExplicitlyChangedPosition()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)player, AEFPermission.BYPASS_ELYTRA.node()).toBoolean()) {
            return;
        }
        Location playerLoc = player.getLocation();
        if (this.config.elytra_enable_netherceiling && ElytraHelper.isNetherCeiling(playerLoc)) {
            return;
        }
        if (this.config.elytra_enable_at_spawn && LocationUtil.getSquaredDistance2DTo00(playerLoc) <= this.config.elytra_spawn_radius_squared) {
            return;
        }
        if (this.global_DenyElytra) {
            if (this.config.elytra_teleport_back) {
                player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
            }
            if (this.config.elytra_actionbar_enabled) {
                player.sendActionBar(AnarchyExploitFixes.translation((Locale)player.locale()).elytra_global_DisabledHere);
            }
            return;
        }
        if (this.global_DenyOnLowTPS && AnarchyExploitFixes.tickReporter().getTPS() <= this.global_DenyElytraTPS) {
            if (this.config.elytra_teleport_back) {
                player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
            }
            if (this.config.elytra_actionbar_enabled) {
                player.sendActionBar(AnarchyExploitFixes.translation((Locale)player.locale()).elytra_global_DisabledLowTPS.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%tps%").replacement(String.valueOf(this.global_DenyElytraTPS)).build()));
            }
            if (this.global_AlsoRemoveOnLowTPS) {
                player.getScheduler().execute((Plugin)this.plugin, () -> {
                    PlayerInventory playerInv = player.getInventory();
                    if (MaterialUtil.isElytra(playerInv.getChestplate())) {
                        ItemStack elytra = playerInv.getChestplate();
                        playerInv.setChestplate(null);
                        player.getWorld().dropItemNaturally(playerLoc, elytra);
                    }
                }, null, 1L);
            }
            return;
        }
        double flySpeed = ElytraHelper.getInstance().getBlocksPerTick(event);
        if (ElytraHelper.getInstance().isInNewChunks(player)) {
            if (this.global_EnableBursting && AnarchyExploitFixes.tickReporter().getTPS() >= this.global_BurstNewChunk_TPS) {
                if (flySpeed > this.global_BurstSpeedNewChunks) {
                    if (this.config.elytra_teleport_back) {
                        player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
                    } else {
                        event.setCancelled(true);
                    }
                    if (this.config.elytra_play_too_fast_sound) {
                        player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
                    }
                    if (!this.config.elytra_actionbar_enabled) {
                        return;
                    }
                    Translation lang = AnarchyExploitFixes.translation(player.locale());
                    if (this.config.elytra_show_chunkage) {
                        player.sendActionBar(lang.elytra_global_TooFastChunkInfo.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_New).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()));
                    } else {
                        player.sendActionBar(lang.elytra_global_TooFast);
                    }
                } else {
                    if (!this.config.elytra_actionbar_enabled) {
                        return;
                    }
                    Translation lang = AnarchyExploitFixes.translation(player.locale());
                    if (this.config.elytra_show_chunkage) {
                        player.sendActionBar(lang.elytra_global_YouAreFlyingIn.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_New_UpperCase).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()).append((Component)Component.space()).append(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_BurstSpeedNewChunks)).build())));
                    } else {
                        player.sendActionBar(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_BurstSpeedNewChunks)).build()));
                    }
                }
            } else if (flySpeed > this.global_SpeedNewChunks) {
                if (this.config.elytra_teleport_back) {
                    player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
                } else {
                    event.setCancelled(true);
                }
                if (this.config.elytra_play_too_fast_sound) {
                    player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
                }
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.locale());
                if (this.global_EnableBursting) {
                    player.sendActionBar(lang.elytra_global_TooFastLowTPS);
                } else if (this.config.elytra_show_chunkage) {
                    player.sendActionBar(lang.elytra_global_TooFastChunkInfo.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_New).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()));
                } else {
                    player.sendActionBar(lang.elytra_global_TooFast);
                }
            } else {
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.locale());
                if (this.config.elytra_show_chunkage) {
                    player.sendActionBar(lang.elytra_global_YouAreFlyingIn.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_New_UpperCase).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()).append((Component)Component.space()).append(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_SpeedNewChunks)).build())));
                } else {
                    player.sendActionBar(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_SpeedNewChunks)).build()));
                }
            }
        } else if (this.global_EnableBursting && AnarchyExploitFixes.tickReporter().getTPS() >= this.global_BurstOldChunk_TPS) {
            if (flySpeed > this.global_BurstSpeedOldChunks) {
                if (this.config.elytra_teleport_back) {
                    player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
                } else {
                    event.setCancelled(true);
                }
                if (this.config.elytra_play_too_fast_sound) {
                    player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
                }
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.locale());
                if (this.config.elytra_show_chunkage) {
                    player.sendActionBar(lang.elytra_global_TooFastChunkInfo.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_Old).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()));
                } else {
                    player.sendActionBar(lang.elytra_global_TooFast);
                }
            } else {
                if (!this.config.elytra_actionbar_enabled) {
                    return;
                }
                Translation lang = AnarchyExploitFixes.translation(player.locale());
                if (this.config.elytra_show_chunkage) {
                    player.sendActionBar(lang.elytra_global_YouAreFlyingIn.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_Old_UpperCase).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()).append((Component)Component.space()).append(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_BurstSpeedOldChunks)).build())));
                } else {
                    player.sendActionBar(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_BurstSpeedOldChunks)).build()));
                }
            }
        } else if (flySpeed > this.global_SpeedOldChunks) {
            if (this.config.elytra_teleport_back) {
                player.teleportAsync(ElytraHelper.getInstance().getSetbackLocation(event));
            } else {
                event.setCancelled(true);
            }
            if (this.config.elytra_play_too_fast_sound) {
                player.playSound(player.getEyeLocation(), this.config.elytra_too_fast_sound, 1.0f, 1.0f);
            }
            if (!this.config.elytra_actionbar_enabled) {
                return;
            }
            Translation lang = AnarchyExploitFixes.translation(player.locale());
            if (this.global_EnableBursting) {
                player.sendActionBar(lang.elytra_global_TooFastLowTPS);
            } else if (this.config.elytra_show_chunkage) {
                player.sendActionBar(lang.elytra_global_TooFastChunkInfo.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_Old).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()));
            } else {
                player.sendActionBar(lang.elytra_global_TooFast);
            }
        } else {
            if (!this.config.elytra_actionbar_enabled) {
                return;
            }
            Translation lang = AnarchyExploitFixes.translation(player.locale());
            if (this.config.elytra_show_chunkage) {
                player.sendActionBar(lang.elytra_global_YouAreFlyingIn.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%neworold%").replacement((ComponentLike)lang.elytra_global_Old_UpperCase).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%chunks%").replacement((ComponentLike)lang.elytra_global_Chunks).build()).append((Component)Component.space()).append(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_SpeedOldChunks)).build())));
            } else {
                player.sendActionBar(lang.elytra_global_Speed.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%speed%").replacement(String.format("%.2f", flySpeed)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%maxspeed%").replacement(String.valueOf(this.global_SpeedOldChunks)).build()));
            }
        }
    }
}

