/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.elytra;

import java.time.Duration;
import java.util.Locale;
import java.util.UUID;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.MaterialUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ElytraPacketFly
extends AEFModule
implements Listener {
    private final long durationMillis;
    private final int maxElytraOpensPerTime;
    private final boolean notify;
    private final boolean kickPlayer;
    private Cache<UUID, Integer> elytraOpenCounts;

    public ElytraPacketFly() {
        super("elytra.packet-elytra-fly", false, "Cheap patch for future/rusherhack/kamiblue 2b2t elytra fly exploit.");
        this.maxElytraOpensPerTime = Math.max(1, this.config.getInt(this.configPath + ".max-elytra-opens-per-time", 25, "The fly exploit causes the player to constantly toggle gliding. \nIf too many glide toggles occur within a timeframe, they are \nmost likely using PacketFly. \nStill may trigger false positives when players are jumping and \nsprinting with elytra equipped, so recommended to play around \nwith the values."));
        this.durationMillis = Math.max(1, this.config.getInt(this.configPath + ".time-in-seconds", 8, "Time in seconds a elytra open count will be remembered by the plugin."));
        this.notify = this.config.getBoolean(this.configPath + ".notify-player-to-disable-packetfly", true, "Configure message in lang folder.");
        this.kickPlayer = this.config.getBoolean(this.configPath + ".kick-instead-of-remove-elytra", false, "If enabled, player will be kicked with a message instead of \ngetting their elytra dropped.");
    }

    @Override
    public void enable() {
        this.elytraOpenCounts = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.durationMillis)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.elytraOpenCounts != null) {
            this.elytraOpenCounts.invalidateAll();
            this.elytraOpenCounts.cleanUp();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onElytraOpen(EntityToggleGlideEvent event) {
        if (event.getEntityType() != XEntityType.PLAYER.get()) {
            return;
        }
        int elytraOpens = this.elytraOpenCounts.get(event.getEntity().getUniqueId(), k -> 0);
        this.elytraOpenCounts.put(event.getEntity().getUniqueId(), ++elytraOpens);
        if (elytraOpens <= this.maxElytraOpensPerTime) {
            return;
        }
        Player player = (Player)event.getEntity();
        this.elytraOpenCounts.asMap().remove(player.getUniqueId());
        if (this.kickPlayer) {
            player.kick(AnarchyExploitFixes.translation((Locale)player.locale()).elytra_disablePacketElytraFly);
            return;
        }
        PlayerInventory playerInv = player.getInventory();
        if (MaterialUtil.isElytra(playerInv.getChestplate())) {
            ItemStack elytra = playerInv.getChestplate();
            playerInv.setChestplate(null);
            player.getWorld().dropItemNaturally(player.getLocation(), elytra);
        }
        if (this.notify) {
            player.sendActionBar(AnarchyExploitFixes.translation((Locale)player.locale()).elytra_disablePacketElytraFly);
        }
    }
}

