/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class BannedMaterials
extends IllegalItemModule {
    private final Set<Material> bannedMaterials;
    private final boolean checkStored;

    public BannedMaterials() {
        super("illegals.ban-specific-materials", false, AEFPermission.BYPASS_ILLEGAL_BANNEDMATERIAL, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_BANNEDMATERIAL.node() + "\nPrevents usage of or deletes items with material that you do not want\nyour players to be able to use.\nUseful if your players have blocks that shouldn't be obtainable in survival.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        List<String> defaults = Stream.of(XMaterial.CHAIN_COMMAND_BLOCK, XMaterial.COMMAND_BLOCK, XMaterial.COMMAND_BLOCK_MINECART, XMaterial.REPEATING_COMMAND_BLOCK, XMaterial.BEDROCK, XMaterial.BARRIER, XMaterial.STRUCTURE_BLOCK, XMaterial.STRUCTURE_VOID, XMaterial.END_PORTAL_FRAME, XMaterial.END_PORTAL, XMaterial.NETHER_PORTAL, XMaterial.LIGHT).filter(XBase::isSupported).map(XMaterial::get).map(Enum::name).collect(Collectors.toList());
        this.bannedMaterials = this.config.getList(this.configPath + ".banned-materials", defaults).stream().map(confMaterial -> {
            try {
                return Material.valueOf((String)confMaterial);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)confMaterial);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return ItemLegality.LEGAL;
        }
        if (this.bannedMaterials.contains(itemStack.getType())) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality != ItemLegality.LEGAL) {
            itemStack.setAmount(0);
        }
    }
}

