/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import io.papermc.paper.datacomponent.DataComponentType;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class IllegalComponentTypes
extends IllegalItemModule {
    private final Set<DataComponentType> illegalComponentTypes;
    private final Set<Material> whitelistedTypes;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;
    private final boolean resetToDefaults;

    public IllegalComponentTypes() {
        super("illegals.components.ban-component-types", false, AEFPermission.BYPASS_ILLEGAL_COMPONENT_TYPES, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_COMPONENT_TYPES.node() + "\nDeletes items that have one or more illegal component types set.");
        this.resetToDefaults = this.config.getBoolean(this.configPath + ".reset-to-defaults", true, "Will reset DataComponent values specified below to their default values for that\nspecific ItemStack instead of just deleting it.\nDepending on your scenario, you might want to set this to false if you dont feel\nlike adding all illegal component types in this list.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false, "If set to true, will check inside shulkers and bundles as well.\nNote: If handling is set to ACTION_ON_USE or STRICT, will delete shulkers / bundles\nif they contain any illegal item.");
        this.illegalComponentTypes = this.config.getList(this.configPath + ".component-types", List.of("minecraft:max_stack_size", "minecraft:consumable"), "The exact DataComponentType you want to filter.").stream().map(configuredType -> {
            NamespacedKey namespacedKey = NamespacedKey.fromString((String)configuredType);
            if (namespacedKey == null) {
                this.notRecognized(NamespacedKey.class, (String)configuredType);
                return null;
            }
            DataComponentType dataComponentType = (DataComponentType)Registry.DATA_COMPONENT_TYPE.get(namespacedKey);
            if (dataComponentType == null) {
                this.notRecognized(DataComponentType.class, (String)configuredType);
            }
            return dataComponentType;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", false);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", List.of(XMaterial.GOLDEN_APPLE.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir()) {
            return ItemLegality.LEGAL;
        }
        if (!this.useWhitelist || this.blacklistMode == this.whitelistedTypes.contains(itemStack.getType())) {
            for (DataComponentType componentType : this.illegalComponentTypes) {
                if (!itemStack.isDataOverridden(componentType)) continue;
                return ItemLegality.ILLEGAL;
            }
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality == ItemLegality.LEGAL) {
            return;
        }
        if (this.resetToDefaults && legality == ItemLegality.ILLEGAL) {
            for (DataComponentType componentType : this.illegalComponentTypes) {
                itemStack.resetData(componentType);
            }
        } else {
            itemStack.setAmount(0);
        }
    }
}

