/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class IllegalFirework
extends IllegalItemModule {
    private final int maxPower;
    private final int minPower;
    private final int maxEffectsAmount;
    private final boolean checkStored;

    public IllegalFirework() {
        super("illegals.firework", false, AEFPermission.BYPASS_ILLEGAL_FIREWORKS, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_FIREWORKS.node() + "\nPrevents usage of or reverts firework items with illegal attributes.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.maxPower = this.config.getInt(this.configPath + ".max-power", 3);
        this.minPower = this.config.getInt(this.configPath + ".min-power", 1);
        this.maxEffectsAmount = this.config.getInt(this.configPath + ".max-effect-count", 7);
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() != XMaterial.FIREWORK_ROCKET.get() || !itemStack.hasItemMeta()) {
            return ItemLegality.LEGAL;
        }
        FireworkMeta fireworkMeta = (FireworkMeta)itemStack.getItemMeta();
        if (fireworkMeta.getPower() > this.maxPower || fireworkMeta.getPower() < this.minPower) {
            return ItemLegality.ILLEGAL;
        }
        if (fireworkMeta.getEffectsSize() > this.maxEffectsAmount) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        switch (legality) {
            case CONTAINS_ILLEGAL: {
                itemStack.setAmount(0);
                break;
            }
            case ILLEGAL: {
                FireworkMeta fireworkMeta = (FireworkMeta)itemStack.getItemMeta();
                if (fireworkMeta.getPower() > this.maxPower) {
                    fireworkMeta.setPower(this.maxPower);
                }
                if (fireworkMeta.getPower() < this.minPower) {
                    fireworkMeta.setPower(this.minPower);
                }
                if (fireworkMeta.getEffectsSize() > this.maxEffectsAmount) {
                    fireworkMeta.clearEffects();
                }
                itemStack.setItemMeta((ItemMeta)fireworkMeta);
            }
        }
    }
}

