/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class IllegalPotions
extends IllegalItemModule {
    private final boolean checkStored;

    public IllegalPotions() {
        super("illegals.potions", false, AEFPermission.BYPASS_ILLEGAL_POTIONS, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_POTIONS.node() + "\nPrevents usage of or reverts items with any custom potion effects or potion colors.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return ItemLegality.LEGAL;
        }
        if (!MaterialUtil.POTIONS.get().contains(itemStack.getType()) && itemStack.getType() != XMaterial.TIPPED_ARROW.get()) {
            return ItemLegality.LEGAL;
        }
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        if (potionMeta.hasCustomEffects() || potionMeta.hasColor()) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        switch (legality) {
            case CONTAINS_ILLEGAL: {
                itemStack.setAmount(0);
                break;
            }
            case ILLEGAL: {
                PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
                potionMeta.setColor(null);
                potionMeta.clearCustomEffects();
                itemStack.setItemMeta((ItemMeta)potionMeta);
            }
        }
    }
}

