/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class ItemAttributes
extends IllegalItemModule {
    private final Set<Material> whitelistedTypes;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;

    public ItemAttributes() {
        super("illegals.attribute-modifiers", false, AEFPermission.BYPASS_ILLEGAL_ATTRIBUTES, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_ATTRIBUTES.node() + "\nPrevents usage of or reverts items with any attribute modifiers\nor item flags.");
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", false);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", true);
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", List.of(XMaterial.TOTEM_OF_UNDYING.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        ItemMeta itemMeta;
        if (itemStack == null || itemStack.getType().isAir() || !itemStack.hasItemMeta()) {
            return ItemLegality.LEGAL;
        }
        if (!(this.useWhitelist && this.blacklistMode != this.whitelistedTypes.contains(itemStack.getType()) || !(itemMeta = itemStack.getItemMeta()).hasAttributeModifiers() && itemMeta.getItemFlags().isEmpty())) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        switch (legality) {
            case CONTAINS_ILLEGAL: {
                itemStack.setAmount(0);
                break;
            }
            case ILLEGAL: {
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setAttributeModifiers(null);
                itemMeta.removeItemFlags(itemMeta.getItemFlags().toArray(new ItemFlag[0]));
                itemStack.setItemMeta(itemMeta);
            }
        }
    }
}

