/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import com.destroystokyo.paper.MaterialTags;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class SpawnEggs
extends IllegalItemModule {
    private final Set<Material> whitelistedTypes;
    private final boolean checkStored;

    public SpawnEggs() {
        super("illegals.ban-spawn-eggs", false, AEFPermission.BYPASS_ILLEGAL_SPAWNEGG, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_SPAWNEGG.node() + "\nDeletes or prevents usage of spawn eggs.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false, "If remove-spawn-eggs is set to true Will delete shulker/bundle \nshould they contain any spawneggs.");
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", Collections.singletonList(XMaterial.VILLAGER_SPAWN_EGG.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || this.whitelistedTypes.contains(itemStack.getType())) {
            return ItemLegality.LEGAL;
        }
        if (MaterialTags.SPAWN_EGGS.isTagged(itemStack)) {
            return ItemLegality.ILLEGAL;
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality != ItemLegality.LEGAL) {
            itemStack.setAmount(0);
        }
    }
}

