/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class Unbreakables
extends IllegalItemModule {
    private final Set<Material> whitelistedTypes;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;

    public Unbreakables() {
        super("illegals.revert-unbreakables", false, AEFPermission.BYPASS_ILLEGAL_UNBREAKABLE, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_UNBREAKABLE.node() + "\nDeletes and prevents usage of unbreakable items.\nThis can be anything from items with illegal damage attributes to\nMetadata/NBT tags.\nNote: Due to the limitations of the API, we can only fully prevent\nusage of these items by deleting them.");
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", false);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", false);
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false, "Will delete shulkers and bundles if they contain unbreakables.");
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", List.of(XMaterial.DIAMOND_CHESTPLATE.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir() || !itemStack.hasItemMeta()) {
            return ItemLegality.LEGAL;
        }
        if (!this.useWhitelist || this.blacklistMode == this.whitelistedTypes.contains(itemStack.getType())) {
            if (itemStack.getItemMeta().isUnbreakable()) {
                return ItemLegality.ILLEGAL;
            }
            if (itemStack.getType().getMaxDurability() == 0) {
                return ItemLegality.LEGAL;
            }
            Damageable damageable = (Damageable)itemStack.getItemMeta();
            if (!damageable.hasDamage()) {
                return ItemLegality.LEGAL;
            }
            if (damageable.getDamage() > itemStack.getType().getMaxDurability() || damageable.getDamage() < 0) {
                return ItemLegality.ILLEGAL;
            }
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        switch (legality) {
            case CONTAINS_ILLEGAL: {
                itemStack.setAmount(0);
                break;
            }
            case ILLEGAL: {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta.isUnbreakable()) {
                    itemMeta.setUnbreakable(false);
                    itemStack.setItemMeta(itemMeta);
                }
                if (itemStack.getType().getMaxDurability() == 0) {
                    return;
                }
                Damageable damageable = (Damageable)itemStack.getItemMeta();
                if (!damageable.hasDamage()) {
                    return;
                }
                if (damageable.getDamage() <= itemStack.getType().getMaxDurability() && damageable.getDamage() >= 0) break;
                damageable.setDamage((int)itemStack.getType().getMaxDurability());
                itemStack.setItemMeta((ItemMeta)damageable);
            }
        }
    }
}

