/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.items.nbt;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.illegals.items.IllegalItemModule;
import me.xginko.aef.utils.ItemUtil;
import me.xginko.aef.utils.enums.IllegalHandling;
import me.xginko.aef.utils.enums.ItemLegality;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class CustomNBTFilter
extends IllegalItemModule {
    private final Set<String> illegalTags;
    private final Set<Material> whitelistedTypes;
    private final boolean useWhitelist;
    private final boolean blacklistMode;
    private final boolean checkStored;

    public CustomNBTFilter() {
        super("illegals.nbt.ban-custom-tags", false, AEFPermission.BYPASS_ILLEGAL_NBT_CUSTOM, "Bypass permission: " + AEFPermission.BYPASS_ILLEGAL_NBT_CUSTOM.node() + "\nDeletes items that have one or more of the configured tags.");
        this.checkStored = this.config.getBoolean(this.configPath + ".check-stored-items", false);
        this.illegalTags = new HashSet<String>(this.config.getList(this.configPath + ".tags", List.of("dmg"), "The exact, case sensitive value of the nbt tag."));
        this.useWhitelist = this.config.getBoolean(this.configPath + ".item-whitelist-enabled", false);
        this.blacklistMode = this.config.getBoolean(this.configPath + ".use-as-blacklist-instead", false);
        this.whitelistedTypes = this.config.getList(this.configPath + ".whitelisted-items", List.of(XMaterial.GOLDEN_APPLE.get().name())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    @NotNull
    public ItemLegality legalityOf(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir()) {
            return ItemLegality.LEGAL;
        }
        if (!this.useWhitelist || this.blacklistMode == this.whitelistedTypes.contains(itemStack.getType())) {
            String nbtItemToString = ItemUtil.getNBTString(itemStack);
            for (String tag : this.illegalTags) {
                if (!nbtItemToString.contains(tag)) continue;
                return ItemLegality.ILLEGAL;
            }
        }
        if (this.checkStored) {
            return this.legalityOf(ItemUtil.getStoredItems(itemStack));
        }
        return ItemLegality.LEGAL;
    }

    @Override
    public void handleItem(ItemStack itemStack, ItemLegality legality) {
        if (this.illegalHandling == IllegalHandling.PREVENT_USE_ONLY) {
            return;
        }
        if (legality != ItemLegality.LEGAL) {
            itemStack.setAmount(0);
        }
    }
}

