/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.placedblocks;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class PeriodicallyRemoveIllegalBlocks
extends AEFModule
implements Consumer<ScheduledTask> {
    private final Set<Material> blocksToRemove;
    private final Set<String> exemptedWorlds;
    private final long checkPeriod;
    private final double pauseTPS;
    private final boolean checkShouldPauseOnLowTPS;
    private ScheduledTask scheduledTask;

    public PeriodicallyRemoveIllegalBlocks() {
        super("illegals.remove-placed-blocks.periodically", false);
        List<String> defaults = Stream.of(XMaterial.PLAYER_HEAD, XMaterial.PLAYER_WALL_HEAD, XMaterial.COMMAND_BLOCK, XMaterial.CHAIN_COMMAND_BLOCK, XMaterial.REPEATING_COMMAND_BLOCK, XMaterial.BEDROCK, XMaterial.BARRIER, XMaterial.STRUCTURE_BLOCK, XMaterial.STRUCTURE_VOID, XMaterial.LIGHT).filter(XBase::isSupported).map(XMaterial::get).map(Enum::name).toList();
        this.blocksToRemove = this.config.getList(this.configPath + ".blocks-to-remove", defaults).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
        this.exemptedWorlds = new HashSet<String>(this.config.getList(this.configPath + ".exempted-worlds", List.of("exampleworld1", "exampleworld2")));
        this.checkPeriod = (long)this.config.getInt(this.configPath + ".check-period-in-seconds", 10) * 20L;
        this.checkShouldPauseOnLowTPS = this.config.getBoolean(this.configPath + ".pause-on-low-TPS", false);
        this.pauseTPS = this.config.getDouble(this.configPath + ".pause-TPS", 14.0);
    }

    @Override
    public void enable() {
        this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, this.checkPeriod, this.checkPeriod);
    }

    @Override
    public void disable() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            if (this.exemptedWorlds.contains(world.getName())) continue;
            int minY = world.getMinHeight();
            int maxY = world.getMaxHeight();
            boolean inNether = world.getEnvironment() == World.Environment.NETHER;
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    if (this.checkShouldPauseOnLowTPS && AnarchyExploitFixes.tickReporter().getTPS() <= this.pauseTPS) {
                        return;
                    }
                    if (!chunk.isEntitiesLoaded()) {
                        return;
                    }
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = minY; y < maxY; ++y) {
                                Block block = chunk.getBlock(x, y, z);
                                if (!this.blocksToRemove.contains(block.getType())) continue;
                                if (block.getType() == XMaterial.BEDROCK.get()) {
                                    if (y <= minY + 4) continue;
                                    if (inNether) {
                                        if (y >= this.config.nether_ceiling_max_y - 5) continue;
                                        block.setType(XMaterial.AIR.get(), false);
                                        continue;
                                    }
                                    block.setType(XMaterial.AIR.get(), false);
                                    continue;
                                }
                                block.setType(XMaterial.AIR.get(), false);
                            }
                        }
                    }
                });
            }
        }
    }
}

