/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.placedblocks;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class RemoveIllegalBlocksOnChunkload
extends AEFModule
implements Listener {
    private final Set<Material> blocksToRemove;
    private final Set<String> exemptedWorlds;
    private final boolean checkShouldPauseOnLowTPS;
    private final double pauseTPS;

    public RemoveIllegalBlocksOnChunkload() {
        super("illegals.remove-placed-blocks.on-chunkload", false, "Remove illegally placed blocks on chunkload.");
        List<String> defaults = Stream.of(XMaterial.PLAYER_HEAD, XMaterial.PLAYER_WALL_HEAD, XMaterial.COMMAND_BLOCK, XMaterial.CHAIN_COMMAND_BLOCK, XMaterial.REPEATING_COMMAND_BLOCK, XMaterial.BEDROCK, XMaterial.BARRIER, XMaterial.STRUCTURE_BLOCK, XMaterial.STRUCTURE_VOID, XMaterial.LIGHT).filter(XBase::isSupported).map(XMaterial::get).map(Enum::name).toList();
        this.blocksToRemove = this.config.getList(this.configPath + ".blocks-to-remove", defaults, "Enter PLAYER_HEAD here if you want to remove placed playerheads.").stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
        this.exemptedWorlds = new HashSet<String>(this.config.getList(this.configPath + ".exempted-worlds", List.of("exampleworld1", "exampleworld2")));
        this.checkShouldPauseOnLowTPS = this.config.getBoolean(this.configPath + ".pause-on-low-TPS", false);
        this.pauseTPS = this.config.getDouble(this.configPath + ".pause-TPS", 14.0);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk()) {
            return;
        }
        if (ChunkUtil.isRetrievalUnsafe(event.getChunk())) {
            return;
        }
        if (this.exemptedWorlds.contains(event.getWorld().getName())) {
            return;
        }
        if (this.checkShouldPauseOnLowTPS && AnarchyExploitFixes.tickReporter().getTPS() <= this.pauseTPS) {
            return;
        }
        int minY = event.getWorld().getMinHeight();
        int maxY = event.getWorld().getMaxHeight();
        boolean inNether = event.getWorld().getEnvironment() == World.Environment.NETHER;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    Block block = event.getChunk().getBlock(x, y, z);
                    if (!this.blocksToRemove.contains(block.getType())) continue;
                    if (block.getType() == XMaterial.BEDROCK.get()) {
                        if (y <= minY + 4) continue;
                        if (inNether) {
                            if (y >= this.config.nether_ceiling_max_y - 5) continue;
                            block.setType(XMaterial.AIR.get(), false);
                            continue;
                        }
                        block.setType(XMaterial.AIR.get(), false);
                        continue;
                    }
                    block.setType(XMaterial.AIR.get(), false);
                }
            }
        }
    }
}

