/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.illegals.placedblocks;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class RemoveUnnaturalSpawners
extends AEFModule
implements Listener {
    private final Map<String, Set<EntityType>> naturalSpawners;
    private final boolean checkShouldPauseOnLowTPS;
    private final double pauseTPS;

    public RemoveUnnaturalSpawners() {
        super("illegals.remove-unnatural-spawners-on-chunkload", false);
        this.checkShouldPauseOnLowTPS = this.config.getBoolean(this.configPath + ".pause-on-low-TPS", false);
        this.pauseTPS = this.config.getDouble(this.configPath + ".pause-TPS", 14.0);
        HashMap<String, Object> defaults = new HashMap<String, Object>(3);
        defaults.put("world", Stream.of(XEntityType.SKELETON, XEntityType.ZOMBIE, XEntityType.SILVERFISH, XEntityType.SPIDER, XEntityType.CAVE_SPIDER, XEntityType.BREEZE).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList()));
        defaults.put("world_nether", Stream.of(XEntityType.BLAZE, XEntityType.MAGMA_CUBE).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList()));
        defaults.put("world_the_end", Stream.of(XEntityType.SKELETON, XEntityType.SPIDER).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList()));
        ConfigSection section = this.config.getConfigSection(this.configPath + ".natural-spawner-types-per-world", defaults, "You can add or remove as much world names here as you want.");
        List<String> worlds = section.getKeys(false);
        this.naturalSpawners = new HashMap<String, Set<EntityType>>(worlds.size());
        for (String world : worlds) {
            this.naturalSpawners.put(world, section.getList(world).stream().map(String::valueOf).map(configuredType -> {
                try {
                    return EntityType.valueOf((String)configuredType);
                }
                catch (IllegalArgumentException e) {
                    this.notRecognized(EntityType.class, (String)configuredType);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class))));
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk()) {
            return;
        }
        if (ChunkUtil.isRetrievalUnsafe(event.getChunk())) {
            return;
        }
        if (!this.naturalSpawners.containsKey(event.getWorld().getName())) {
            return;
        }
        if (this.checkShouldPauseOnLowTPS && AnarchyExploitFixes.tickReporter().getTPS() <= this.pauseTPS) {
            return;
        }
        int minY = event.getWorld().getMinHeight();
        int maxY = event.getWorld().getMaxHeight();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    Block block = event.getChunk().getBlock(x, y, z);
                    if (block.getType() != XMaterial.SPAWNER.get() || this.naturalSpawners.get(event.getWorld().getName()).contains(((CreatureSpawner)block.getState()).getSpawnedType())) continue;
                    block.setType(XMaterial.AIR.get(), false);
                }
            }
        }
    }
}

