/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.models.ChunkUID;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;

public class KeepStashLoaded
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final Map<String, Double> worldsAndTheirRadiuses;
    private final Set<Material> storageTypes;
    private final long minInhabitedTime;
    private final long keepLoadedMillis;
    private final long checkDelayTicks;
    private final int stashCount;
    private final boolean logIsEnabled;
    private final boolean onlyTileEntities;
    private Map<ChunkUID, Long> forceLoadedChunks;
    private ScheduledTask chunkUnloadTask;

    public KeepStashLoaded() {
        super("lag-preventions.keep-stash-chunks-loaded", false, "Idea by 3b3t admin kumori (Soft1k) \nImproves lag generated by large stash chunks constantly loading and \nunloading by setting them force loaded. This might cause increased ram \nusage, so keep an eye out for that.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", false);
        this.stashCount = this.config.getInt(this.configPath + ".container-block-threshold", 50, "How many container blocks have to be in a chunk for it to be seen \nas a stash chunk to keep force loaded.");
        this.checkDelayTicks = this.config.getInt(this.configPath + ".check-delay-ticks", 200, "Ticks to wait after a chunk is loaded before it will be checked. \nReduces lag by fast travelling players.");
        this.minInhabitedTime = this.config.getInt(this.configPath + ".min-chunk-inhabited-time-ticks", 1000, "The minimum time in ticks a chunk has to have been inhabited to be checked.");
        this.keepLoadedMillis = TimeUnit.MINUTES.toMillis(this.config.getInt(this.configPath + ".keep-loaded-minutes", 120, "The time in minutes a stash chunks will be kept force loaded before \nsetting it back to normal."));
        this.onlyTileEntities = this.config.getBoolean(this.configPath + ".only-check-tile-entities", true, "Set to false if you want to check more blocks than just tile entities. \nMakes the overall speed of the module faster if set to true.");
        this.storageTypes = this.config.getList(this.configPath + ".container-types", MaterialUtil.INVENTORY_HOLDERS.get().stream().map(Enum::name).collect(Collectors.toList())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("world", 100);
        defaults.put("world_nether", 100);
        defaults.put("world_the_end", 100);
        ConfigSection section = this.config.getConfigSection(this.configPath + ".worlds", defaults, "Radiuses around spawn in chunks (not blocks) that should not be checked.\nWorlds not on this list are exempt from all checking.");
        List<String> worlds = section.getKeys(false);
        this.worldsAndTheirRadiuses = new HashMap<String, Double>(worlds.size());
        for (String world : worlds) {
            try {
                int radius = Integer.parseInt(section.getString(world));
                this.worldsAndTheirRadiuses.put(world, NumberConversions.square((double)radius));
            }
            catch (NumberFormatException e) {
                this.warn("Radius for world '" + world + "' is not a valid integer.");
            }
        }
    }

    @Override
    public void enable() {
        this.forceLoadedChunks = new ConcurrentHashMap<ChunkUID, Long>();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.chunkUnloadTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.chunkUnloadTask != null) {
            this.chunkUnloadTask.cancel();
            this.chunkUnloadTask = null;
        }
        if (this.forceLoadedChunks != null) {
            for (Map.Entry<ChunkUID, Long> entry : this.forceLoadedChunks.entrySet()) {
                entry.getKey().getChunkAsync(false).thenAccept(chunk -> {
                    if (chunk != null) {
                        ChunkUtil.setForceLoaded(chunk, false);
                    }
                });
            }
            this.forceLoadedChunks.clear();
            this.forceLoadedChunks = null;
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (Map.Entry<ChunkUID, Long> entry : this.forceLoadedChunks.entrySet()) {
            if (System.currentTimeMillis() < entry.getValue()) continue;
            entry.getKey().getChunkAsync(false).thenAccept(chunk -> {
                if (chunk == null) {
                    this.forceLoadedChunks.remove(entry.getKey());
                    if (this.logIsEnabled) {
                        this.info("Removing key that returned a null chunk: " + String.valueOf(entry.getKey()) + ".");
                    }
                    return;
                }
                this.plugin.getServer().getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> {
                    chunk.setForceLoaded(false);
                    this.forceLoadedChunks.remove(entry.getKey());
                    if (this.logIsEnabled) {
                        this.info("Set chunk " + String.valueOf(entry.getKey()) + " to no longer force loaded.");
                    }
                });
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk()) {
            return;
        }
        String world = event.getWorld().getName();
        if (!this.worldsAndTheirRadiuses.containsKey(world)) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (chunk.getInhabitedTime() < this.minInhabitedTime) {
            return;
        }
        if (NumberConversions.square((double)chunk.getX()) + NumberConversions.square((double)chunk.getZ()) < this.worldsAndTheirRadiuses.get(world)) {
            return;
        }
        this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, chunk.getWorld(), chunk.getX(), chunk.getZ(), delayedCheck -> {
            if (!chunk.isLoaded()) {
                return;
            }
            int count = 0;
            if (this.onlyTileEntities) {
                for (BlockState tileEntity : chunk.getTileEntities()) {
                    if (!this.storageTypes.contains(tileEntity.getType()) || ++count <= this.stashCount) continue;
                    chunk.setForceLoaded(true);
                    this.forceLoadedChunks.computeIfAbsent(ChunkUID.of(chunk), chunkUID -> {
                        if (this.logIsEnabled) {
                            this.info("Set chunk " + String.valueOf(chunkUID) + " to force loaded.");
                        }
                        return System.currentTimeMillis() + this.keepLoadedMillis;
                    });
                    return;
                }
                return;
            }
            int minY = chunk.getWorld().getMinHeight();
            int maxY = chunk.getWorld().getMaxHeight();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = minY; y < maxY; ++y) {
                        if (!this.storageTypes.contains(chunk.getBlock(x, y, z).getType()) || ++count <= this.stashCount) continue;
                        chunk.setForceLoaded(true);
                        this.forceLoadedChunks.computeIfAbsent(ChunkUID.of(chunk), chunkUID -> {
                            if (this.logIsEnabled) {
                                this.info("Set chunk " + String.valueOf(chunkUID) + " to force loaded.");
                            }
                            return System.currentTimeMillis() + this.keepLoadedMillis;
                        });
                        return;
                    }
                }
            }
        }, this.checkDelayTicks);
    }
}

