/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions;

import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.BundleUtil;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.plugin.Plugin;

public class NoBundleDrops
extends AEFModule
implements Listener {
    public NoBundleDrops() {
        super("lag-preventions.anti-bundle-drops", false, "Disables bundles dropping stored items when the bundle is a dropped item itself.\n(So for example when blown up.)\nThis helps fix client and server lag when done often and fast.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityDropItem(EntityDropItemEvent event) {
        if (event.getEntityType() != XEntityType.ITEM.get()) {
            return;
        }
        Item item = (Item)event.getEntity();
        if (BundleUtil.isBundle(item.getItemStack())) {
            event.setCancelled(true);
            item.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntityType() != XEntityType.ITEM.get()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Item item = (Item)event.getEntity();
        if (event.getFinalDamage() < (double)item.getHealth()) {
            return;
        }
        if (BundleUtil.isBundle(item.getItemStack())) {
            event.setCancelled(true);
            item.remove();
        }
    }
}

