/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions;

import com.destroystokyo.paper.MaterialTags;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class NoShulkerDrops
extends AEFModule
implements Listener {
    public NoShulkerDrops() {
        super("lag-preventions.anti-shulker-drops", false, "Disables shulkers dropping stored items when blown up. \nThis helps fix client- and serverside lag when done often and fast.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntityType() != XEntityType.ITEM.get()) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            Item item = (Item)event.getEntity();
            if (!MaterialTags.SHULKER_BOXES.isTagged(item.getItemStack())) {
                return;
            }
            if (event.getFinalDamage() >= (double)item.getHealth()) {
                event.setCancelled(true);
                item.remove();
            }
        }
    }
}

