/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions;

import com.destroystokyo.paper.MaterialTags;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.models.ChunkUID;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class StashExplosions
extends AEFModule
implements Listener {
    private final Set<Material> storageTypes;
    private final long waitTimeSeconds;
    private final int amountAtWhichToTakeAction;
    private final boolean logIsEnabled;
    private Cache<ChunkUID, Integer> containerExplosions;

    public StashExplosions() {
        super("lag-preventions.disable-item-drops-during-large-stash-explosions", false, "Explodes containers without dropping items after a certain amount \nof exploded containers per chunk.");
        this.logIsEnabled = this.config.getBoolean(this.configPath + ".log", false);
        this.amountAtWhichToTakeAction = this.config.getInt(this.configPath + ".min-explosions-before-drops-disable", 6, "How many container blocks in a chunk can be blown up until items \nno longer drop from them.");
        this.waitTimeSeconds = Math.max(1, this.config.getInt(this.configPath + ".time-in-seconds", 3, "The time in seconds to wait after an explosion for another one to happen. \nIf no explosion happens within x seconds after the first one, the count resets to 0."));
        this.storageTypes = this.config.getList(this.configPath + ".container-types", MaterialUtil.INVENTORY_HOLDERS.get().stream().filter(material -> !MaterialTags.SHULKER_BOXES.isTagged(material)).map(Enum::name).collect(Collectors.toList())).stream().map(configuredType -> {
            try {
                return Material.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(Material.class)));
    }

    @Override
    public void enable() {
        this.containerExplosions = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.waitTimeSeconds)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.containerExplosions != null) {
            this.containerExplosions.invalidateAll();
            this.containerExplosions.cleanUp();
            this.containerExplosions = null;
        }
    }

    private void handleExplosion(Chunk chunk, List<Block> affectedBlocks) {
        ChunkUID chunkUID = ChunkUID.of(chunk);
        int containerExplosionsInChunk = this.containerExplosions.get(chunkUID, k -> 0);
        if (containerExplosionsInChunk > this.amountAtWhichToTakeAction) {
            if (this.logIsEnabled) {
                this.info("Not dropping contents of storage block(s) affected by explosion at chunk x:" + chunk.getX() + ", z:" + chunk.getZ() + " because more than " + this.amountAtWhichToTakeAction + " containers have already exploded within the configured timeframe.");
            }
            affectedBlocks.removeIf(block -> {
                if (this.storageTypes.contains(block.getType())) {
                    block.setType(XMaterial.AIR.get());
                    return true;
                }
                return false;
            });
            return;
        }
        for (Block toExplode : affectedBlocks) {
            if (!this.storageTypes.contains(toExplode.getType())) continue;
            ++containerExplosionsInChunk;
        }
        this.containerExplosions.put(chunkUID, containerExplosionsInChunk);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockExplode(BlockExplodeEvent event) {
        this.handleExplosion(event.getBlock().getChunk(), event.blockList());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityExplode(EntityExplodeEvent event) {
        if (event.getEntityType() == XEntityType.WIND_CHARGE.get()) {
            return;
        }
        if (event.getEntityType() == XEntityType.BREEZE_WIND_CHARGE.get()) {
            return;
        }
        this.handleExplosion(event.getEntity().getChunk(), event.blockList());
    }
}

