/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.agelimits;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.plugin.Plugin;

public class CustomAgeLimits
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final Map<EntityType, Integer> entityLimits = new EnumMap<EntityType, Integer>(EntityType.class);
    private final long checkPeriod;
    private final boolean logIsEnabled = this.config.getBoolean(this.configPath + ".log-removals", false);
    private final boolean forceLoadEntities;
    private ScheduledTask scheduledTask;

    public CustomAgeLimits() {
        super("lag-preventions.entity-age-limits.custom-limits", false, "Kill certain entities after a custom amount of ticks lived.");
        this.checkPeriod = this.config.getInt(this.configPath + ".check-period-in-ticks", 1200, "Check all loaded chunks every x ticks.");
        this.forceLoadEntities = this.config.getBoolean(this.configPath + ".forceload-entities", false, "When a chunk is loaded, entities inside of it are not necessarily \nloaded as well. Force loading is worse for performance, but there \nmight be a scenario where this turns out to be useful.");
        EnumMap<XEntityType, Integer> defaults = new EnumMap<XEntityType, Integer>(XEntityType.class);
        defaults.put(XEntityType.ARROW, 120);
        defaults.put(XEntityType.SPECTRAL_ARROW, 120);
        defaults.put(XEntityType.FALLING_BLOCK, 160);
        defaults.put(XEntityType.WITHER_SKULL, 100);
        defaults.put(XEntityType.SNOWBALL, 100);
        TreeMap<String, Object> versionDefaults = new TreeMap<String, Object>();
        for (Map.Entry entry : defaults.entrySet()) {
            if (!((XEntityType)entry.getKey()).isSupported()) continue;
            versionDefaults.put(((XEntityType)entry.getKey()).get().name(), entry.getValue());
        }
        ConfigSection section = this.config.getConfigSection(this.configPath + ".limited-types", versionDefaults, "Check the paper api for correct EntityType enums:\nhttps://jd.papermc.io/paper/1.20/org/bukkit/entity/EntityType.html\nMake sure your minecraft version is matching as well.");
        for (String configuredEntity : section.getKeys(false)) {
            try {
                EntityType limitedEntity = EntityType.valueOf((String)configuredEntity);
                Integer maxAmountPerChunk = Integer.parseInt(section.getString(configuredEntity));
                this.entityLimits.put(limitedEntity, maxAmountPerChunk);
            }
            catch (NumberFormatException e) {
                this.notRecognized(Integer.class, configuredEntity);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(Material.class, configuredEntity);
            }
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, 20L, this.checkPeriod);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    if (!this.forceLoadEntities && !chunk.isEntitiesLoaded()) {
                        return;
                    }
                    for (Entity entity : chunk.getEntities()) {
                        entity.getScheduler().execute((Plugin)this.plugin, () -> {
                            if (this.entityLimits.containsKey(entity.getType()) && entity.getTicksLived() > this.entityLimits.get(entity.getType())) {
                                entity.remove();
                                if (this.logIsEnabled) {
                                    this.info("Removed " + entity.getType().name() + " due to old age.");
                                }
                            }
                        }, null, 1L);
                    }
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntitiesLoad(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            if (!this.entityLimits.containsKey(entity.getType()) || entity.getTicksLived() <= this.entityLimits.get(entity.getType())) continue;
            entity.getScheduler().execute((Plugin)this.plugin, () -> ((Entity)entity).remove(), null, 1L);
            if (!this.logIsEnabled) continue;
            this.info("Removed " + entity.getType().name() + " due to old age.");
        }
    }
}

