/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.agelimits;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import me.xginko.aef.utils.EntityUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class ProjectileAgeLimit
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final Set<EntityType> ignoredTypes;
    private final long check_period_in_ticks;
    private final int max_alive_time;
    private ScheduledTask scheduledTask;

    public ProjectileAgeLimit() {
        super("lag-preventions.entity-age-limits.projectile-limit", false, "Patches any lag exploit that abuses spawning a ton of projectile entities\n(ex. Snowball exploit).\nSkips over the following entities: ENDER_PEARL, FISHING_HOOK, WITHER_SKULL\nand ENDER_SIGNAL. You can configure those separately in the custom entity age\nlimit section.");
        this.max_alive_time = this.config.getInt(this.configPath + ".max-alive-time-ticks", 300, "(20 ticks = 1 second) Will not touch Ender Pearls");
        this.check_period_in_ticks = (long)this.config.getInt(this.configPath + ".check-period-seconds", 20, "How frequently we should check all projectiles for their alive time") * 20L;
        List<String> defaults = Stream.of(XEntityType.FISHING_BOBBER, XEntityType.ENDER_PEARL, XEntityType.WITHER_SKULL, XEntityType.EYE_OF_ENDER).filter(XBase::isSupported).map(XEntityType::get).map(Enum::name).collect(Collectors.toList());
        this.ignoredTypes = this.config.getList(this.configPath + ".ignored-types", defaults).stream().map(configuredType -> {
            try {
                return EntityType.valueOf((String)configuredType);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(EntityType.class, (String)configuredType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class)));
    }

    @Override
    public void enable() {
        this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, this.check_period_in_ticks, this.check_period_in_ticks);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    for (Entity entity : chunk.getEntities()) {
                        entity.getScheduler().execute((Plugin)this.plugin, () -> {
                            if (this.ignoredTypes.contains(entity.getType())) {
                                return;
                            }
                            if (EntityUtil.isProjectile(entity) && entity.getTicksLived() > this.max_alive_time) {
                                entity.remove();
                            }
                        }, null, 1L);
                    }
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk()) {
            return;
        }
        if (ChunkUtil.isRetrievalUnsafe(event.getChunk())) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            entity.getScheduler().execute((Plugin)this.plugin, () -> {
                if (this.ignoredTypes.contains(entity.getType())) {
                    return;
                }
                if (EntityUtil.isProjectile(entity) && entity.getTicksLived() > this.max_alive_time) {
                    entity.remove();
                }
            }, null, 1L);
        }
    }
}

