/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.regionalactivity;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.lagpreventions.regionalactivity.RegionalEntityActivityModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.util.NumberConversions;

public class Pathfinding
extends RegionalEntityActivityModule {
    private final Map<EntityType, Double> typedDistanceLimits = new EnumMap<EntityType, Double>(EntityType.class);
    private final double globalMaxDistanceSquared;
    private final boolean globalDistanceEnabled = this.config.getBoolean(this.configPath + ".distance-limit.global-limit.enable", false);
    private final boolean perTypeDistanceEnabled;

    public Pathfinding() {
        super("entity-pathfinding", false, true, 4000, 1500.0, 6000, 10000, 14.0, 120.0, Map.of(XEntityType.VILLAGER, 1000), "Limits entities deciding to pathfind to a specific location \nwithin a configurable radius and timeframe to help reduce lag \nby cancelling burst activity hotspots.");
        this.globalMaxDistanceSquared = NumberConversions.square((double)this.config.getDouble(this.configPath + ".distance-limit.global-limit.max-target-distance", 20.0, "The max distance no mob pathfinding should exceed. \nYou always want this to be higher than your highest max distance \nfor a specific mob."));
        this.perTypeDistanceEnabled = this.config.getBoolean(this.configPath + ".distance-limit.custom-limits.enable", true);
        EnumMap<XEntityType, Double> defaults = new EnumMap<XEntityType, Double>(XEntityType.class);
        defaults.put(XEntityType.ZOMBIE, 6.0);
        defaults.put(XEntityType.SKELETON, 6.0);
        defaults.put(XEntityType.WITHER_SKELETON, 8.0);
        defaults.put(XEntityType.ZOMBIE_VILLAGER, 10.0);
        defaults.put(XEntityType.ZOMBIFIED_PIGLIN, 8.0);
        defaults.put(XEntityType.WITHER, 8.0);
        TreeMap<String, Object> versionDefaults = new TreeMap<String, Object>();
        for (Map.Entry entry : defaults.entrySet()) {
            if (!((XEntityType)entry.getKey()).isSupported()) continue;
            versionDefaults.put(((XEntityType)entry.getKey()).get().name(), entry.getValue());
        }
        ConfigSection section = this.config.getConfigSection(this.configPath + ".distance-limit.custom-limits.entities", versionDefaults);
        for (String configuredEntity : section.getKeys(false)) {
            try {
                Double maxDistanceSquared = NumberConversions.square((double)Double.parseDouble(section.getString(configuredEntity)));
                EntityType limitedEntity = EntityType.valueOf((String)configuredEntity);
                this.typedDistanceLimits.put(limitedEntity, maxDistanceSquared);
            }
            catch (NumberFormatException e) {
                this.notRecognized(Double.class, configuredEntity);
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(EntityType.class, configuredEntity);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityPathfind(EntityPathfindEvent event) {
        double targetDistanceSquared;
        if (this.shouldCancelEntityEvent(event)) {
            event.setCancelled(true);
            return;
        }
        if (!this.globalDistanceEnabled && !this.perTypeDistanceEnabled) {
            return;
        }
        try {
            targetDistanceSquared = event.getEntity().getLocation().distanceSquared(event.getLoc());
        }
        catch (IllegalArgumentException e) {
            if (this.logIsEnabled) {
                this.error("Unable to measure distance between entity and target.", e);
            }
            return;
        }
        if (this.globalDistanceEnabled && targetDistanceSquared > this.globalMaxDistanceSquared) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Cancelled pathfinding for entity " + String.valueOf(event.getEntityType()) + " at " + LocationUtil.toString(event.getEntity().getLocation()) + " because the target is further than the global limit. Distance: " + Math.sqrt(targetDistanceSquared));
            }
            return;
        }
        if (this.perTypeDistanceEnabled && this.typedDistanceLimits.containsKey(event.getEntityType()) && targetDistanceSquared > this.typedDistanceLimits.get(event.getEntityType())) {
            event.setCancelled(true);
            if (this.logIsEnabled) {
                this.info("Cancelled pathfinding for entity " + String.valueOf(event.getEntityType()) + " at " + LocationUtil.toString(event.getEntity().getLocation()) + " because the target is further than its configured limit. Distance: " + Math.sqrt(targetDistanceSquared));
            }
        }
    }
}

