/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.regionalactivity;

import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.models.BlockRegion2D;
import me.xginko.aef.utils.models.Lazy;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class RegionalActivityModule
extends AEFModule
implements Listener {
    protected final long cacheTimeMillis;
    protected final long pauseTimeMillis;
    protected final double checkRadius;
    protected final double pauseTPS;
    protected final double pauseMSPT;
    protected final int totalActivityLimit;
    protected final boolean logIsEnabled;
    protected Cache<BlockRegion2D, RegionData> regionDataCache;

    public RegionalActivityModule(String subConfigPath, boolean defEnabled, boolean deflogEnabled, int totalLimit, double defCheckRadius, int defPauseMillis, int defCacheMillis, double defPauseTPS, double defPauseMSPT) {
        this(subConfigPath, defEnabled, deflogEnabled, totalLimit, defCheckRadius, defPauseMillis, defCacheMillis, defPauseTPS, defPauseMSPT, null);
    }

    public RegionalActivityModule(String subConfigPath, boolean defEnabled, boolean deflogEnabled, int defTotalLimit, double defCheckRadius, int defPauseMillis, int defCacheMillis, double defPauseTPS, double defPauseMSPT, String comment) {
        super("lag-preventions.regional-activity." + subConfigPath, defEnabled, comment);
        String configPath = "lag-preventions.regional-activity." + subConfigPath;
        this.logIsEnabled = this.config.getBoolean(configPath + ".log", deflogEnabled);
        this.totalActivityLimit = this.config.getInt(configPath + ".total-limit", defTotalLimit, "The maximum amount of measured activity of this type that is allowed\nto happen within the configured timeframe (cache-millis).\nThis value should always be higher than any of the configured per type limits.");
        this.checkRadius = this.config.getDouble(configPath + ".check-radius-blocks", defCheckRadius, "The radius in blocks in which activity will be grouped together and measured.");
        this.pauseTimeMillis = this.config.getInt(configPath + ".pause-time-millis", defPauseMillis, "The time in milliseconds all related activity will be blocked if it exceeded\nthe configured limit.");
        this.cacheTimeMillis = Math.max(100L, (long)this.config.getInt(configPath + ".data-keep-time-millis", defCacheMillis, "The time in milliseconds before a region and its data will be expired\nif no activity has been detected.\nFor proper functionality, needs to be at least as long as your pause time."));
        this.pauseTPS = this.config.getDouble(configPath + ".pause-TPS", defPauseTPS, "The TPS at which to cancel the physics entirely.");
        this.pauseMSPT = this.config.getDouble(configPath + ".pause-MSPT", defPauseMSPT, "The MSPT at which to cancel the physics entirely.");
    }

    @Override
    public void enable() {
        this.regionDataCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(this.cacheTimeMillis)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.regionDataCache != null) {
            this.regionDataCache.invalidateAll();
            this.regionDataCache.cleanUp();
            this.regionDataCache = null;
        }
    }

    @NotNull
    protected BlockRegion2D getRegion(Location location) {
        for (Map.Entry regionDataEntry : this.regionDataCache.asMap().entrySet()) {
            if (!((BlockRegion2D)regionDataEntry.getKey()).contains(location)) continue;
            return (BlockRegion2D)regionDataEntry.getKey();
        }
        BlockRegion2D region = BlockRegion2D.of(location.getWorld(), location.getX(), location.getZ(), this.checkRadius);
        this.regionDataCache.put(region, new RegionData(region));
        return region;
    }

    @NotNull
    protected RegionData getRegionData(Location location) {
        return this.regionDataCache.get(this.getRegion(location), RegionData::new);
    }

    protected <T extends Event> boolean shouldCancelEvent(T event, Location location) {
        return this.shouldCancelBecauseLagging(event) || this.shouldCancelBecauseTotalActivity(event, location);
    }

    protected <T extends Event> boolean shouldCancelBecauseLagging(T event) {
        double ticksPerSecond = AnarchyExploitFixes.tickReporter().getTPS();
        double milliSecondsPerTick = AnarchyExploitFixes.tickReporter().getMSPT();
        if (ticksPerSecond <= this.pauseTPS || milliSecondsPerTick >= this.pauseMSPT) {
            if (this.logIsEnabled) {
                this.info("Cancelling " + event.getClass().getSimpleName() + " because server is lagging. (tps=" + String.format("%.4f", ticksPerSecond) + " | mspt=" + String.format("%.4f", milliSecondsPerTick) + ")");
            }
            return true;
        }
        return false;
    }

    protected <T extends Event> boolean shouldCancelBecauseTotalActivity(T event, Location location) {
        RegionData regionData = this.getRegionData(location);
        if (regionData.getTotalActivityData().resumeTimeMillis.get() > System.currentTimeMillis()) {
            if (this.logIsEnabled) {
                this.info("Cancelling " + event.getClass().getSimpleName() + " indiscriminately at " + LocationUtil.toString(location) + " because the region exceeded the total activity limit.");
            }
            return true;
        }
        if (regionData.getTotalActivityData().activityCount.incrementAndGet() > this.totalActivityLimit) {
            if (this.logIsEnabled) {
                this.info("Disabling in a radius of " + this.checkRadius + " blocks from center at x=" + regionData.region.getCenterX() + ", z=" + regionData.region.getCenterZ() + " in world " + location.getWorld().getName() + " for " + this.pauseTimeMillis + "ms, because of too high activity within the configured timeframe: " + String.valueOf(regionData.getTotalActivityData().activityCount) + " (limit: " + this.totalActivityLimit + ")");
            }
            regionData.getTotalActivityData().resumeTimeMillis.set(System.currentTimeMillis() + this.pauseTimeMillis);
            regionData.getTotalActivityData().activityCount.set(0);
            return true;
        }
        return false;
    }

    protected static class RegionData {
        public final BlockRegion2D region;
        private final ActivityData totalActivityData;
        private final Lazy<Map<Material, ActivityData>> blockActivityData;
        private final Lazy<Map<EntityType, ActivityData>> entityActivityData;

        public RegionData(BlockRegion2D region) {
            this.region = region;
            this.totalActivityData = new ActivityData();
            this.blockActivityData = Lazy.of(() -> new EnumMap(Material.class));
            this.entityActivityData = Lazy.of(() -> new EnumMap(EntityType.class));
        }

        public ActivityData getTotalActivityData() {
            return this.totalActivityData;
        }

        public ActivityData getBlockActivityData(Material material) {
            return this.blockActivityData.get().computeIfAbsent(material, k -> new ActivityData());
        }

        public ActivityData getEntityActivityData(EntityType entityType) {
            return this.entityActivityData.get().computeIfAbsent(entityType, k -> new ActivityData());
        }

        public static class ActivityData {
            public final AtomicInteger activityCount = new AtomicInteger();
            public final AtomicLong resumeTimeMillis = new AtomicLong();
        }
    }
}

