/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.lagpreventions.regionalactivity;

import me.xginko.aef.modules.lagpreventions.regionalactivity.RegionalActivityModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.SculkBloomEvent;

public class SculkBloom
extends RegionalActivityModule {
    private final int maxCharge;
    private final boolean chargeLimitEnabled;

    public SculkBloom() {
        super("sculk-bloom", false, true, 600, 1500.0, 6000, 10000, 10.0, 120.0, "Limits sculk blooming within a configurable radius and timeframe \nto help reduce lag by cancelling high activity hotspots. \n \nExamples: \n \n- An entity was killed and dropped experience within an 8-block \n  radius of a SculkCatalyst. \n- A plugin used SculkCatalyst.bloom(Block, int)");
        this.chargeLimitEnabled = this.config.getBoolean(this.configPath + ".charge-limit.enable", false, "Limit the charge power of sculk blooming, which determines to how many blocks\nthe sculk will spread after an entity dies near a catalyst.");
        this.maxCharge = Math.max(0, Math.min(1000, this.config.getInt(this.configPath + ".charge-limit.max-charge", 20, "Typically, charges will be set to the exp reward of a mob (DroppedExp),\nwhich is usually 3-5 for animals, and 5-10 for the average mob (up to 50 for wither skeletons).\nRoughly speaking, for each charge, 1 more sculk block will be placed.\nCan only be between 0-1000.")));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onSkulkBloom(SculkBloomEvent event) {
        if (this.chargeLimitEnabled && event.getCharge() > this.maxCharge) {
            if (this.logIsEnabled) {
                this.info("Limiting Sculk charge limit (charge=" + event.getCharge() + "|max=" + this.maxCharge + ") at " + LocationUtil.toString(event.getBlock().getLocation()));
            }
            event.setCharge(this.maxCharge);
            return;
        }
        if (this.shouldCancelEvent(event, event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }
}

