/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.misc;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.ChunkUtil;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class BedrockFiller
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final Map<String, Set<Integer>> worldBedrockLevels;
    private final double pauseTPS;
    private final double pauseMSPT;
    private final long checkPeriodTicks;
    private final boolean pauseOnLag;
    private final boolean fillOnChunkLoad;
    private final boolean fillPeriodically;
    private ScheduledTask scheduledTask;

    public BedrockFiller() {
        super("misc.bedrock-filler", false, "Fills holes in bedrock layers.");
        this.fillOnChunkLoad = this.config.getBoolean(this.configPath + ".fill-on-chunkload", false);
        this.fillPeriodically = this.config.getBoolean(this.configPath + ".fill-periodically", true);
        this.checkPeriodTicks = (long)this.config.getInt(this.configPath + ".check-period-seconds", 30) * 20L;
        this.pauseOnLag = this.config.getBoolean(this.configPath + ".pause-on-lag", true);
        this.pauseTPS = this.config.getDouble(this.configPath + ".pause-tps", 16.0);
        this.pauseMSPT = this.config.getDouble(this.configPath + ".pause-mspt", 100.0);
        ConfigSection worldLevelsSection = this.config.getConfigSection(this.configPath + ".world-levels", Map.of("world", List.of(Integer.valueOf(-64)), "world_nether", List.of(Integer.valueOf(127), Integer.valueOf(0))));
        List<String> worlds = worldLevelsSection.getKeys(false);
        this.worldBedrockLevels = new HashMap<String, Set<Integer>>(worlds.size());
        for (String world : worlds) {
            Set yLevels = worldLevelsSection.getList(world).stream().map(configuredYLevel -> {
                if (configuredYLevel instanceof Integer) {
                    Integer integer = (Integer)configuredYLevel;
                    return integer;
                }
                try {
                    if (configuredYLevel instanceof String) {
                        String string = (String)configuredYLevel;
                        return Integer.parseInt(string);
                    }
                    throw new IllegalArgumentException();
                }
                catch (Throwable t) {
                    this.warn("y-level for world '" + world + "' is not a valid integer.");
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (yLevels.isEmpty()) continue;
            this.worldBedrockLevels.put(world, yLevels);
        }
    }

    @Override
    public void enable() {
        if (this.fillOnChunkLoad) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        if (this.fillPeriodically) {
            this.scheduledTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, 1L, this.checkPeriodTicks);
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk() || ChunkUtil.isRetrievalUnsafe(event.getChunk())) {
            return;
        }
        if (!this.worldBedrockLevels.containsKey(event.getWorld().getName())) {
            return;
        }
        if (this.pauseOnLag && this.isRegionLagging()) {
            return;
        }
        for (int yLevel : this.worldBedrockLevels.get(event.getWorld().getName())) {
            ChunkUtil.setLayerOf(XMaterial.BEDROCK.get(), yLevel, event.getChunk());
        }
    }

    @Override
    public void accept(ScheduledTask task) {
        for (World world : this.plugin.getServer().getWorlds()) {
            if (!this.worldBedrockLevels.containsKey(world.getName())) continue;
            for (Chunk chunk : world.getLoadedChunks()) {
                if (ChunkUtil.isRetrievalUnsafe(chunk)) continue;
                this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    if (this.pauseOnLag && this.isRegionLagging()) {
                        return;
                    }
                    if (chunk.isLoaded()) {
                        for (int yLevel : this.worldBedrockLevels.get(world.getName())) {
                            ChunkUtil.setLayerOf(XMaterial.BEDROCK.get(), yLevel, chunk);
                        }
                    }
                });
            }
        }
    }

    private boolean isRegionLagging() {
        return AnarchyExploitFixes.tickReporter().getTPS() <= this.pauseTPS || AnarchyExploitFixes.tickReporter().getMSPT() >= this.pauseMSPT;
    }
}

