/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.misc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.enums.AEFKey;
import me.xginko.aef.utils.permissions.AEFPermission;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FirstJoinMessages
extends AEFModule
implements Listener {
    private final AtomicInteger totalPlayers = new AtomicInteger(0);
    private final boolean logFirstJoin = this.config.getBoolean(this.configPath + ".show-in-console", true);

    public FirstJoinMessages() {
        super("misc.join-leave-messages.first-join-messages", false, "Configure message in lang folder.\nYou can hide yourself and other players using the permission:\n" + AEFPermission.SILENT_JOIN.node());
    }

    @Override
    public void enable() {
        CompletableFuture.runAsync(() -> this.totalPlayers.set(this.plugin.getServer().getOfflinePlayers().length)).thenRun(() -> this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin));
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    private boolean shouldSendMessage(@NotNull Player player) {
        if (!player.getPersistentDataContainer().has(AEFKey.FIRSTJOIN_MSG_TOGGLE.getKey())) {
            return this.config.firstJoinMsgsAreOnByDefault;
        }
        return (Boolean)player.getPersistentDataContainer().get(AEFKey.FIRSTJOIN_MSG_TOGGLE.getKey(), PersistentDataType.BOOLEAN);
    }

    private void sendFirstJoinMessage(@NotNull Audience receiver, @NotNull Player joiningPlayer, int joinNumber) {
        boolean isConsoleMessage;
        Component joiningPlayerName = joiningPlayer.name();
        TextComponent joiningPlayerNumber = Component.text((String)Integer.toString(joinNumber));
        for (Component messageLine : AnarchyExploitFixes.translation((Pointered)((isConsoleMessage = receiver instanceof ConsoleCommandSender) ? joiningPlayer : receiver)).misc_firstJoinMessage) {
            Component newMessageLine = messageLine.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%player%").replacement((ComponentLike)joiningPlayerName).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%players_num%").replacement((ComponentLike)joiningPlayerNumber).build());
            if (isConsoleMessage) {
                newMessageLine = newMessageLine.append((Component)Component.text((String)("(" + String.valueOf(joiningPlayer.locale()) + ")")));
            }
            receiver.sendMessage(newMessageLine);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerJoin(PlayerJoinEvent event) {
        Player joiningPlayer = event.getPlayer();
        if (joiningPlayer.hasPlayedBefore()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)joiningPlayer, AEFPermission.SILENT_JOIN.node()).toBoolean()) {
            return;
        }
        int joiningPlayersNumber = this.totalPlayers.incrementAndGet();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            onlinePlayer.getScheduler().run((Plugin)this.plugin, firstJoinMsgTask -> {
                if (this.shouldSendMessage(onlinePlayer)) {
                    this.sendFirstJoinMessage((Audience)onlinePlayer, joiningPlayer, joiningPlayersNumber);
                }
            }, null);
        }
        if (this.logFirstJoin) {
            this.sendFirstJoinMessage((Audience)this.plugin.getServer().getConsoleSender(), joiningPlayer, joiningPlayersNumber);
        }
    }
}

