/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.misc;

import java.util.Locale;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.enums.AEFKey;
import me.xginko.aef.utils.permissions.AEFPermission;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class JoinLeaveMessages
extends AEFModule
implements Listener {
    private final boolean showInConsole;
    private final boolean firstJoinEnabled;

    public JoinLeaveMessages() {
        super("misc.join-leave-messages", false, "If you want to hide yourself or someone else when logging\ninto the game, use these permissions:\n" + AEFPermission.SILENT_JOIN.node() + ", " + AEFPermission.SILENT_LEAVE.node());
        this.showInConsole = this.config.getBoolean(this.configPath + ".show-in-console", false);
        this.firstJoinEnabled = this.config.getBoolean(this.configPath + ".first-join-messages.enable", false);
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    private boolean shouldSendMessage(@NotNull Player player) {
        if (!player.getPersistentDataContainer().has(AEFKey.CONNECT_MSG_TOGGLE.getKey())) {
            return this.config.connectionMsgsAreOnByDefault;
        }
        return (Boolean)player.getPersistentDataContainer().get(AEFKey.CONNECT_MSG_TOGGLE.getKey(), PersistentDataType.BOOLEAN);
    }

    private void sendJoinMessage(@NotNull Audience receiver, @NotNull Player joiningPlayer) {
        boolean isConsoleMessage;
        Component joinMessage = AnarchyExploitFixes.translation((Pointered)((isConsoleMessage = receiver instanceof ConsoleCommandSender) ? joiningPlayer : receiver)).misc_joinMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%player%").replacement((ComponentLike)joiningPlayer.name()).build());
        if (isConsoleMessage) {
            joinMessage = joinMessage.append((Component)Component.text((String)("(" + String.valueOf(joiningPlayer.locale()) + ")")));
        }
        receiver.sendMessage(joinMessage);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerJoinEvent(PlayerJoinEvent event) {
        event.joinMessage(null);
        Player joiningPlayer = event.getPlayer();
        if (this.firstJoinEnabled && !joiningPlayer.hasPlayedBefore()) {
            return;
        }
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)joiningPlayer, AEFPermission.SILENT_JOIN.node()).toBoolean()) {
            return;
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            onlinePlayer.getScheduler().execute((Plugin)this.plugin, () -> {
                if (this.shouldSendMessage(onlinePlayer)) {
                    onlinePlayer.sendMessage(AnarchyExploitFixes.translation((Locale)onlinePlayer.locale()).misc_joinMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%player%").replacement((ComponentLike)joiningPlayer.name()).build()));
                }
            }, null, 1L);
        }
        if (this.showInConsole) {
            this.sendJoinMessage((Audience)this.plugin.getServer().getConsoleSender(), joiningPlayer);
        }
    }

    private void sendLeaveMessage(@NotNull Audience receiver, @NotNull Player leavingPlayer) {
        boolean isConsoleMessage;
        Component joinMessage = AnarchyExploitFixes.translation((Pointered)((isConsoleMessage = receiver instanceof ConsoleCommandSender) ? leavingPlayer : receiver)).misc_leaveMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%player%").replacement((ComponentLike)leavingPlayer.name()).build());
        if (isConsoleMessage) {
            joinMessage = joinMessage.append((Component)Component.text((String)("(" + String.valueOf(leavingPlayer.locale()) + ")")));
        }
        receiver.sendMessage(joinMessage);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerLeaveEvent(PlayerQuitEvent event) {
        event.quitMessage(null);
        Player leavingPlayer = event.getPlayer();
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)leavingPlayer, AEFPermission.SILENT_LEAVE.node()).toBoolean()) {
            return;
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            onlinePlayer.getScheduler().execute((Plugin)this.plugin, () -> {
                if (onlinePlayer.getUniqueId().equals(leavingPlayer.getUniqueId())) {
                    return;
                }
                if (this.shouldSendMessage(onlinePlayer)) {
                    onlinePlayer.sendMessage(AnarchyExploitFixes.translation((Locale)onlinePlayer.locale()).misc_leaveMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%player%").replacement((ComponentLike)leavingPlayer.name()).build()));
                }
            }, null, 1L);
        }
        if (this.showInConsole) {
            this.sendLeaveMessage((Audience)this.plugin.getServer().getConsoleSender(), leavingPlayer);
        }
    }
}

