/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClientStatus;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.enums.Platform;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class BedTrap
extends PacketModule
implements Listener {
    private final long timeInSeconds;
    private final int maxDeathsPerTime;
    private final boolean shouldLog;
    private Set<UUID> deadPlayers;
    private Cache<UUID, AtomicInteger> playerDeathNearBedCount;

    public BedTrap() {
        super("preventions.anti-bed-trap", false, PacketListenerPriority.MONITOR, "Resets a players bed respawn they die too many times within \na certain timeframe.");
        this.maxDeathsPerTime = this.config.getInt(this.configPath + ".max-deaths-per-time", 7, "Amount of times player can die until he is determined as bed-trapped.");
        this.timeInSeconds = Math.max(1, this.config.getInt(this.configPath + ".time-in-seconds", 5, "\"Time until death counter will be reset again."));
        this.shouldLog = this.config.getBoolean(this.configPath + ".log", false);
    }

    @Override
    public void enable() {
        this.deadPlayers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.playerDeathNearBedCount = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.timeInSeconds)).build();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        if (Platform.FOLIA.isPresent()) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (Platform.FOLIA.isPresent()) {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
        }
        if (this.deadPlayers != null) {
            this.deadPlayers.clear();
            this.deadPlayers = null;
        }
        if (this.playerDeathNearBedCount != null) {
            this.playerDeathNearBedCount.invalidateAll();
            this.playerDeathNearBedCount.cleanUp();
            this.playerDeathNearBedCount = null;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerDeath(PlayerDeathEvent event) {
        if (Platform.FOLIA.isPresent()) {
            this.deadPlayers.add(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerPostRespawn(PlayerPostRespawnEvent event) {
        if (!event.isBedSpawn()) {
            return;
        }
        if (this.playerDeathNearBedCount.get(event.getPlayer().getUniqueId(), k -> new AtomicInteger()).incrementAndGet() <= this.maxDeathsPerTime) {
            return;
        }
        event.getPlayer().getScheduler().execute((Plugin)this.plugin, () -> {
            try {
                event.getPlayer().setRespawnLocation(null, true);
            }
            catch (NoSuchMethodError e) {
                event.getPlayer().setBedSpawnLocation(null, true);
            }
            if (this.shouldLog) {
                this.info("Reset bed respawn of potentially bed-trapped player '" + event.getPlayer().getName() + "'");
            }
        }, null, 1L);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        if (event.getPacketType() != PacketType.Play.Client.CLIENT_STATUS) {
            return;
        }
        if (new WrapperPlayClientClientStatus(event).getAction() != WrapperPlayClientClientStatus.Action.PERFORM_RESPAWN) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.deadPlayers.contains(player.getUniqueId()) && !player.isDead()) {
            return;
        }
        player.getScheduler().execute((Plugin)this.plugin, () -> {
            Location potentialBedSpawn = player.getPotentialBedLocation();
            if (potentialBedSpawn == null || potentialBedSpawn.distanceSquared(player.getLocation()) > 16.0) {
                return;
            }
            if (this.playerDeathNearBedCount.get(player.getUniqueId(), k -> new AtomicInteger()).incrementAndGet() <= this.maxDeathsPerTime) {
                return;
            }
            try {
                player.setRespawnLocation(null, true);
            }
            catch (NoSuchMethodError e) {
                player.setBedSpawnLocation(null, true);
            }
            if (this.shouldLog) {
                this.info("Reset bed respawn of potentially bed-trapped player '" + player.getName() + "'");
            }
            this.deadPlayers.remove(player.getUniqueId());
        }, null, 20L);
    }
}

