/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.xginko.aef.modules.packets.PacketModule;

public class BigArguments
extends PacketModule {
    private final int charLimit;
    private final boolean log;
    private final boolean kick;

    public BigArguments() {
        super("patches.message-char-limit", true, PacketListenerPriority.HIGHEST, "Sets a character limit for command and message packets to prevent a lag exploit.");
        this.charLimit = this.config.getInt(this.configPath + ".max-characters", 256);
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if ((event.getPacketType() == PacketType.Play.Client.CHAT_MESSAGE || event.getPacketType() == PacketType.Play.Client.CHAT_COMMAND || event.getPacketType() == PacketType.Play.Client.CHAT_COMMAND_UNSIGNED) && this.isStringTooBig(event)) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
        }
    }

    private boolean isStringTooBig(PacketReceiveEvent event) {
        int strBufLen = ByteBufHelper.readVarInt((Object)event.getByteBuf());
        if (strBufLen < 0 || strBufLen > this.charLimit * 4) {
            return true;
        }
        return ByteBufHelper.toString((Object)event.getByteBuf(), (int)ByteBufHelper.readerIndex((Object)event.getByteBuf()), (int)strBufLen, (Charset)StandardCharsets.UTF_8).length() > this.charLimit;
    }
}

