/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.PacketUtil;
import me.xginko.aef.utils.models.ExpiringSet;

public class CustomPayloadWhitelist
extends PacketModule {
    private final Set<String> whitelistedChannels;
    private final int maxNameLength;
    private final boolean log;
    private Cache<SocketAddress, ExpiringSet<String>> loggingCooldown;

    public CustomPayloadWhitelist() {
        super("patches.custom-payload-whitelist", false, PacketListenerPriority.HIGHEST, "A blanket protection against players abusing custom payload listeners in plugins.\nCancels all player-sent custom payload packets if the channel name isn't configured in this\nwhitelist.\nIdeally, if your server doesn't require any client-side mods (ex. voicechat), you shouldn't\nneed to configure anything here.");
        this.log = this.config.getBoolean(this.configPath + ".log", true);
        this.maxNameLength = this.config.getInt(this.configPath + ".max-channel-name-length", Short.MAX_VALUE);
        this.whitelistedChannels = this.config.getList(this.configPath + ".whitelisted-channels", List.of("minecraft:register", "minecraft:unregister", "minecraft:brand")).stream().map(channel -> channel.toLowerCase(Locale.ROOT)).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public void enable() {
        if (this.log) {
            this.loggingCooldown = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(15L)).build();
        }
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
    }

    @Override
    public void disable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
        if (this.loggingCooldown != null) {
            this.loggingCooldown.invalidateAll();
            this.loggingCooldown.cleanUp();
            this.loggingCooldown = null;
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.PLUGIN_MESSAGE) {
            return;
        }
        String channelName = PacketUtil.readStringOrInvalid(event.getByteBuf(), this.maxNameLength);
        if (this.whitelistedChannels.contains(channelName.toLowerCase(Locale.ROOT))) {
            return;
        }
        event.setCancelled(true);
        if (this.log && !this.loggingCooldown.get(event.getAddress(), address -> new ExpiringSet(Duration.ofSeconds(3L))).contains(channelName)) {
            this.warn((event.getUser() == null ? event.getAddress().toString() : event.getUser().getName()) + " tried to send payload in " + channelName + " channel");
        }
    }
}

