/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientCraftRecipeRequest;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSetDisplayedRecipe;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.List;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.enums.Platform;
import me.xginko.aef.utils.reflection.ReflectionUtil;

public class InvalidRecipeID
extends PacketModule {
    private final boolean log;
    private final boolean kick;
    private List<?> allRecipeDisplays;

    public InvalidRecipeID() {
        super("patches.invalid-recipe-id", Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2), PacketListenerPriority.HIGHEST, "Prevents console error spamming of IndexOutOfBoundsException from bad recipe packets.\nOnly relevant for 1.21.2+");
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    @Override
    public void enable() {
        try {
            Class<?> recipeManagerClass = ReflectionUtil.findClass("net.minecraft.world.item.crafting.RecipeManager");
            Field allDisplaysField = ReflectionUtil.findField(recipeManagerClass, "allDisplays");
            MethodHandle getRecipeManagerMethod = ReflectionUtil.findMethod(ReflectionUtil.MC_SERVER_CLASS.get(), "getRecipeManager", recipeManagerClass, new Class[0]);
            this.allRecipeDisplays = (List)allDisplaysField.get(getRecipeManagerMethod.invoke(ReflectionUtil.MC_SERVER_INSTANCE.get()));
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
        }
        catch (Throwable t) {
            this.error("Error during reflective operation! Is your version even affected by this exploit?", t);
            this.disable();
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        int recipeIndex;
        if (event.isCancelled() || event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.SET_DISPLAYED_RECIPE) {
            recipeIndex = new WrapperPlayClientSetDisplayedRecipe(event).getRecipeId().getId();
        } else if (event.getPacketType() == PacketType.Play.Client.CRAFT_RECIPE_REQUEST) {
            recipeIndex = new WrapperPlayClientCraftRecipeRequest(event).getRecipeId().getId();
        } else {
            return;
        }
        if (recipeIndex < 0 || recipeIndex >= this.allRecipeDisplays.size()) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
        }
    }
}

