/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.enums.Platform;

public class InvalidSequence
extends PacketModule {
    private final boolean log;
    private final boolean kick;

    public InvalidSequence() {
        super("patches.sequence-crash-patch", Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19) && !Platform.getServerVersion().isOlderThan(ServerVersion.V_1_20_1), PacketListenerPriority.HIGHEST, "Patches a variety of lag/crash exploits that involves sending packets \nwith invalid sequences.");
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        int sequence;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            sequence = new WrapperPlayClientPlayerBlockPlacement(event).getSequence();
        } else if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            sequence = new WrapperPlayClientPlayerDigging(event).getSequence();
        } else if (event.getPacketType() == PacketType.Play.Client.USE_ITEM) {
            sequence = new WrapperPlayClientUseItem(event).getSequence();
        } else {
            return;
        }
        if (sequence < 0) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
        }
    }
}

